package com.yd.api.result;

import java.io.Serializable;

public class CommonResult implements Serializable {
	private static final long serialVersionUID = 1L;
	private Boolean success; 	//执行是否成功
	private String code;	//ZHB错误编码
	private String message;	//ZHB错误信息
	private String errorCode;	//其他平台错误编码
	private String errorMessage;	//其他平台错误编码
	private String flag;
	/**
	 * 执行是否成功
	 * @return
	 */
	public Boolean isSuccess() {
		return success;
	}
	/**
	 * 执行是否成功
	 * @param success
	 */
	public void setSuccess(Boolean success) {
		this.success = success;
	}
	/**
	 * 获取属性    code
	 * @return  code 最惠比平台对应的错误编码
	 */
	public String getCode() {
		return code;
	}
	/**
	 * 属性赋值  code
	 * @param code 最惠比平台对应的错误编码
	 */
	public void setCode(String code) {
		this.code = code;
	}
	/**
	 * 获取属性    message
	 * @return 最惠比平台对应的错误信息
	 */
	public String getMessage() {
		return message;
	}
	/**
	 * 属性赋值  message
	 * @param message 最惠比平台对应的错误信息
	 */
	public void setMessage(String message) {
		this.message = message;
	}
	/**
	 * 获取属性    errorCode
	 * @return	其他平台对应的错误编码
	 */
	public String getErrorCode() {
		return errorCode;
	}
	/**
	 * 属性赋值  errorCode
	 * @param errorCode 其他平台对应的错误编码
	 */
	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}
	/**
	 * 获取属性    errorMessage
	 * @return	其他平台对应的错误信息
	 */
	public String getErrorMessage() {
		return errorMessage;
	}
	/**
	 * 属性赋值  errorMessage
	 * @param errorMessage	其他平台对应的错误信息
	 */
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}
	public String getFlag() {
		return flag;
	}
	public void setFlag(String flag) {
		this.flag = flag;
	}
	public CommonResult() {
		super();
	}
	/**
	 * @param success	是否执行成功
	 * @param message	最惠比平台错误信息
	 */
	public CommonResult(Boolean success, String message) {
		super();
		this.success = success;
		this.message = message;
	}
	/**
	 * @param success	是否执行成功
	 * @param message	最惠比平台错误信息
	 * @param errorCode	其他平台错误编码
	 */
	public CommonResult(Boolean success, String message,String errorCode) {
		super();
		this.success = success;
		this.message = message;
		this.errorCode = errorCode;
	}
	/**
	 * @param success	是否执行成功
	 * @param message	最惠比平台错误信息
	 * @param errorCode	其他平台错误编码
	 * @param errorMessage	其他平台错误信息
	 */
	public CommonResult(Boolean success, String message,String errorCode,String errorMessage) {
		super();
		this.success = success;
		this.message = message;
		this.errorCode = errorCode;
		this.errorMessage = errorMessage;
	}
	
}
