package com.yd.api.agms.service.impl;

import com.google.common.base.Strings;
import com.yd.api.agms.service.AgmsDashboardService;
import com.yd.api.agms.vo.dashboard.*;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.agms.dashboard.StatisticsOpportunityInfo;
import com.yd.dal.entity.agms.dashboard.StatisticsPEPInfo;
import com.yd.dal.entity.meta.MdDropOptions;
import com.yd.dal.service.agms.AgmsDashboardDALService;
import com.yd.dal.service.meta.MdDropOptionsDALService;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

@Service("agmsDashboardService")
public class AgmsDashboardServiceImpl implements AgmsDashboardService {

    @Autowired
    private AgmsDashboardDALService agmsDashboardDALService;
    @Autowired
    private MdDropOptionsDALService mdDropOptionsDALService;

    @Override
    public StatisticsPEPResponseVO statisticsPEP(StatisticsPEPRequestVO requestVO) {
        //AGMS -- Dashboard查询  PEP活动管理
        StatisticsPEPResponseVO responseVO = new StatisticsPEPResponseVO();
        MdDropOptions mdDropOptions = mdDropOptionsDALService.selectByMasterCodeAndOptionsCode("bizchance_promotion_action","refused");
        List<StatisticsPEPInfo> statisticsPEPInfos = agmsDashboardDALService.statisticsPEP(requestVO.getType(),mdDropOptions.getId());
        responseVO.setStatisticsPEPInfos(statisticsPEPInfos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public StatisticsOpportunityResponseVO statisticsOpportunity(StatisticsOpportunityRequestVO requestVO) {
        //AGMS -- Dashboard查询  商机预测
        StatisticsOpportunityResponseVO responseVO = new StatisticsOpportunityResponseVO();
        MdDropOptions mdDropOptions = mdDropOptionsDALService.selectByMasterCodeAndOptionsCode("bizchance_promotion_action","refused");
        List<StatisticsOpportunityInfo> statisticsOpportunityInfos = agmsDashboardDALService.statisticsOpportunity(requestVO.getType(),requestVO.getTime(),mdDropOptions.getId());
        responseVO.setStatisticsOpportunityInfos(statisticsOpportunityInfos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public StatisticsForecastTotalResponseVO statisticsForecastTotal(StatisticsForecastTotalRequestVO requestVO) {
        //AGMS -- Dashboard查询  预测统计查询
        StatisticsForecastTotalResponseVO responseVO = new StatisticsForecastTotalResponseVO();
        MdDropOptions mdDropOptions = mdDropOptionsDALService.selectByMasterCodeAndOptionsCode("bizchance_promotion_action","refused");
        List<StatisticsOpportunityInfo> statisticsOpportunityInfos = agmsDashboardDALService.statisticsOpportunity("total",requestVO.getTime(),mdDropOptions.getId());
        List<StatisticsPEPInfo> statisticsPEPInfos = agmsDashboardDALService.statisticsPEP("total",mdDropOptions.getId());
        if (!statisticsOpportunityInfos.isEmpty()){
            StatisticsOpportunityInfo statisticsOpportunityInfo = statisticsOpportunityInfos.get(0);
            responseVO.setOpportunityNum(statisticsOpportunityInfo.getOpportunityNum());
            responseVO.setPredictFYC(statisticsOpportunityInfo.getPredictFYC());
            responseVO.setPredictFYP(statisticsOpportunityInfo.getPredictFYP());
            responseVO.setPieces(statisticsOpportunityInfo.getOpportunityNum());
        }

        if (!statisticsPEPInfos.isEmpty()){
            StatisticsPEPInfo statisticsPEPInfo = statisticsPEPInfos.get(0);
            String time = requestVO.getTime();
            switch (time.toLowerCase()){
                case ("d"):
                    responseVO.setScore(statisticsPEPInfo.getScoreDay());
                    break;
                case ("w"):
                    responseVO.setScore(statisticsPEPInfo.getScoreWeek());
                    break;
                case ("m"):
                    responseVO.setScore(statisticsPEPInfo.getScoreMonth());
                    break;
                case ("q"):
                    responseVO.setScore(statisticsPEPInfo.getScoreQuarter());
                    break;
                case ("y"):
                    responseVO.setScore(statisticsPEPInfo.getScoreYear());
                    break;
            }
        }

        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public StatisticsSalesResponseVO statisticsSales(StatisticsSalesRequestVO requestVO) {
        StatisticsSalesResponseVO responseVO = new StatisticsSalesResponseVO();
        String category = requestVO.getCategory();
        String time = requestVO.getTime();
        String type = requestVO.getType();
        category = Strings.isNullOrEmpty(category) ? "all" : category;
        time = Strings.isNullOrEmpty(time) ? "m" : time;
        type = Strings.isNullOrEmpty(type) ? "b" : type;
        List<StatisticsSalesInfo> statisticsSalesInfos;
        if("life".equals(category)){//寿险
            statisticsSalesInfos = agmsDashboardDALService.statisticsSalesEG(type,time);
        }else if("pc".equals(category)){//产险
            statisticsSalesInfos = agmsDashboardDALService.statisticsSalesYD(type,time);
        }else{
            statisticsSalesInfos = getAll(type,time);
        }
        responseVO.setStatisticsSalesInfos(statisticsSalesInfos);
        responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    /**
     * dashBoard -- 寿险+产险销售统计
     * @param type 类型
     * @param time 时间
     * @return 数据
     */
    private List<StatisticsSalesInfo> getAll(String type, String time) {
        StatisticsSalesInfo statisticsSalesInfo = new StatisticsSalesInfo();
        List<StatisticsSalesInfo> statisticsSalesInfos = new ArrayList<>();
        String unitPremium = "0";
        double fyp = 0D,fyc = 0D;
        Integer pieces = 0;
        List<StatisticsSalesInfo> statisticsSalesInfosLife = agmsDashboardDALService.statisticsSalesEG(type,time);
        List<StatisticsSalesInfo> statisticsSalesInfosPC = agmsDashboardDALService.statisticsSalesYD(type,time);
        statisticsSalesInfosLife.addAll(statisticsSalesInfosPC);
        if(statisticsSalesInfosLife.size() > 0){
            for(StatisticsSalesInfo item : statisticsSalesInfosLife){
                fyp += Double.parseDouble(item.getFyp());
                fyc += Double.parseDouble(item.getFyc());
                pieces += item.getPieces();
            }
            if(pieces != 0){
                unitPremium = BigDecimal.valueOf(fyp / pieces).setScale(2,BigDecimal.ROUND_HALF_UP).toString();
            }
        }
        statisticsSalesInfo.setFyc(new DecimalFormat("0.00").format(fyc));
        statisticsSalesInfo.setFyp(new DecimalFormat("0.00").format(fyp));
        statisticsSalesInfo.setPieces(pieces);
        statisticsSalesInfo.setUnitPremium(unitPremium);
        statisticsSalesInfo.setTypeName("寿险+财险");
        statisticsSalesInfos.add(statisticsSalesInfo);
        return statisticsSalesInfos;
    }

    @Override
    public StatisticsPractitionerResponseVO statisticsPractitioner(StatisticsPractitionerRequestVO requestVO) {
        StatisticsPractitionerResponseVO responseVO = new StatisticsPractitionerResponseVO();
        String type = requestVO.getType();
        type = Strings.isNullOrEmpty(type) ? "b" : type;
        List<StatisticsPractitionerInfo> statisticsPractitionerInfos = agmsDashboardDALService.statisticsPractitioner(type);

        responseVO.setStatisticsPractitionerInfos(statisticsPractitionerInfos);
        responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

}
