package com.yd.dal.service.agms.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yd.api.agms.vo.practitioner.*;
import com.yd.dal.mapper.agms.AgmsPractitionerMapper;
import com.yd.dal.service.agms.AgmsPractitionerDALService;
import com.yd.util.CommonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author xxy
 */
@Service("agmsPractitionerDALService")
public class AgmsPractitionerDALServiceImpl implements AgmsPractitionerDALService {

    @Autowired
    private AgmsPractitionerMapper mapper;
    @Override
    public PageInfo<PractitionerFileSharing> practitionerFileSharingList(Long id ,Long practitionerId, String itemType,String shareCode,Long[] mdDropOptionIds, Integer isActive, int pageNum, int size) {
        PageHelper.startPage(pageNum, size);
        Page<PractitionerFileSharing> practitionerFileShares = mapper.practitionerFileSharingList(id,practitionerId,itemType,shareCode,mdDropOptionIds,isActive);
        return new PageInfo<>(practitionerFileShares);
    }

    @Override
    public SharePractitionerInfo findSharePractitioner(String shareCode) {
        if (CommonUtil.isNullOrBlank(shareCode)){
            return null;
        }
        return mapper.findSharePractitioner(shareCode);
    }

    @Override
    public List<PractitionerScheduleInfo> practitionerSchedule(PractitionerScheduleRequestVO requestVO) {
        return mapper.practitionerSchedule(requestVO);
    }

    @Override
    public List<PractitionerLeadsGoalsInfo> practitionerLeadsGoals(PractitionerLeadsGoalsRequestVO requestVO) {
        return mapper.practitionerLeadsGoals(requestVO);
    }

    @Override
    public List<Map<String, Object>> practitionerScheduleExport(PractitionerScheduleRequestVO requestVO) {
        return mapper.practitionerScheduleExport(requestVO);
    }

    @Override
    public List<Map<String, Object>> practitionerLeadsGoalsExport(PractitionerLeadsGoalsRequestVO requestVO) {
        return mapper.practitionerLeadsGoalsExport(requestVO);
    }

    @Override
    public List<PractitionerActivityInfo> practitionerActivity(PractitionerActivityRequestVO requestVO) {
        return mapper.practitionerActivity(requestVO);
    }

    @Override
    public List<Map<String, Object>> practitionerActivityExport(PractitionerActivityRequestVO requestVO) {
        return mapper.practitionerActivityExport(requestVO);
    }
}
