package com.yd.rmi.tencent.wechat.vo.accesstoken;
/**
 * https://open.weixin.qq.com/cgi-bin/showdocument?action=dir_list&t=resource/res_list&verify=1&id=open1419318590&token=&lang=zh_CN
 * 代公众号发起网页授权
	简介
		在公众号授权托管给第三方平台后，第三方平台可以根据本文档相关说明，代替授权公众号发起网页授权。关于OAuth2.0的详细介绍，可以参考OAuth2.0协议标准
		作为第三方平台开发商，需要拥有自己的appid以及secret（在创建第三方平台并获得审核成功后可以获取），以及确保授权的公众号具备授权作用域的权限，以及用于回调的域名。
	授权流程
		微信目前支持Authorization code授权模式，主要流程分为两步：
		1. 获取code
		2. 通过code换取accesstoken
 *
 */
public class AccessTokenByCodeRequest {
/*
 	!!!	开放平台的文档中对于这个接口的描述和公众平台有差异！下面是开放平台中截取的（在公众平台中入参没有component_appid和component_access_token，有secret）
	第二步：通过code换取access_token
		请求方法
			获取第一步的code后，请求以下链接获取access_token：
			https://api.weixin.qq.com/sns/oauth2/component/access_token?appid=APPID&code=CODE&grant_type=authorization_code&component_appid=COMPONENT_APPID&component_access_token=COMPONENT_ACCESS_TOKEN    
			需要注意的是，由于安全方面的考虑，对访问该链接的客户端有IP白名单的要求。
		参数说明
			参数 是否必须 说明 
			appid 是 公众号的appid 
			code 是 填写第一步获取的code参数 
			grant_type 是 填authorization_code 
			component_appid 是 服务开发方的appid 
			component_access_token 是 服务开发方的access_token 
		返回说明
			正确的返回：
			{
			"access_token":"ACCESS_TOKEN",
			"expires_in":7200,
			"refresh_token":"REFRESH_TOKEN",
			"openid":"OPENID",
			"scope":"SCOPE"
			}
		参数 说明 
			access_token 接口调用凭证 
			expires_in access_token接口调用凭证超时时间，单位（秒） 
			refresh_token 用户刷新access_token 
			openid 授权用户唯一标识 
			scope 用户授权的作用域，使用逗号（,）分隔 
		错误返回样例：
			{"errcode":40029,"errmsg":"invalid code"}

 */
	private String appid;
	private String secret;
	private String code;
	private String grant_type;
	private String component_appid;
	private String component_access_token;
	public String getAppid() {
		return appid;
	}
	public void setAppid(String appid) {
		this.appid = appid;
	}
	public String getSecret() {
		return secret;
	}
	public void setSecret(String secret) {
		this.secret = secret;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public String getGrant_type() {
		return grant_type;
	}
	public void setGrant_type(String grant_type) {
		this.grant_type = grant_type;
	}
	public String getComponent_appid() {
		return component_appid;
	}
	public void setComponent_appid(String component_appid) {
		this.component_appid = component_appid;
	}
	public String getComponent_access_token() {
		return component_access_token;
	}
	public void setComponent_access_token(String component_access_token) {
		this.component_access_token = component_access_token;
	}
}