package com.yd.dal.service.product.impl;

import com.yd.dal.entity.product.Product;
import com.yd.dal.entity.product.ProductE;
import com.yd.dal.mapper.product.ProductMapper;
import com.yd.dal.service.product.ProductDALService;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("productDALService")
public class ProductDALServiceImpl implements ProductDALService {
    @Autowired
    private ProductMapper productMapper;

    @Override
    public List<Product> findAll() {
        return productMapper.findAll();
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<ProductE> findAllE() {
        return productMapper.findAllE();
    }

    @Override
    public Product findById(Long productId) {
        return productMapper.selectByPrimaryKey(productId);
    }
}
