package com.yd.dal.service.customer.impl;

import com.yd.dal.entity.customer.AclPractitionerPotentialGoals;
import com.yd.dal.mapper.customer.AclPractitionerPotentialGoalsMapper;
import com.yd.dal.service.customer.AclPractitionerPotentialGoalsDALService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("aclPractitionerPotentialGoalsDALService")
public class AclPractitionerPotentialGoalsDALServiceImpl implements AclPractitionerPotentialGoalsDALService {

    @Autowired
    private AclPractitionerPotentialGoalsMapper aclPractitionerPotentialGoalsMapper;
    @Override
    public List<AclPractitionerPotentialGoals> findByPractitionerAndCurrentYear(Long practitionerId, Integer currentYear) {
        return aclPractitionerPotentialGoalsMapper.findByPractitionerAndCurrentYear(practitionerId,currentYear);
    }

    @Override
    public void updateList(List<AclPractitionerPotentialGoals> potentialGoalsUpdateList) {
        for(AclPractitionerPotentialGoals item : potentialGoalsUpdateList){
            aclPractitionerPotentialGoalsMapper.updateByPrimaryKeySelective(item);
        }

    }

    @Override
    public void saveAll(List<AclPractitionerPotentialGoals> potentialGoalsList) {
        aclPractitionerPotentialGoalsMapper.saveAll(potentialGoalsList);
    }

    @Override
    public List<AclPractitionerPotentialGoals> findByPractitionerAndCurrentYearAndTimeUnit(Long practitionerId, Integer currentYear, List<Integer> timeTypeList) {
        return aclPractitionerPotentialGoalsMapper.findByPractitionerAndCurrentYearAndTimeUnit(practitionerId,currentYear,timeTypeList);
    }
}
