package com.yd.dal.service.customer.impl;

import com.yd.dal.entity.customer.AclCustomerFortuneStatistic;
import com.yd.dal.mapper.customer.AclCustomerFortuneStatisticMapper;
import com.yd.dal.service.customer.AclCustomerFortuneStatisticDALService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xxy
 */
@Service("aclCustomerFortuneStatisticDALService")
public class AclCustomerFortuneStatisticDALServiceImpl implements AclCustomerFortuneStatisticDALService {

    @Autowired
    private AclCustomerFortuneStatisticMapper customerFortuneStatisticMapper;

    @Override
    public List<AclCustomerFortuneStatistic> findByCustomerIds(Long[] customerIds) {
        return customerFortuneStatisticMapper.findByCustomerIds(customerIds);
    }

    @Override
    public void updateAll(List<AclCustomerFortuneStatistic> customerFortuneStatistics) {
        customerFortuneStatisticMapper.updateBatch(customerFortuneStatistics);
    }

    @Override
    public AclCustomerFortuneStatistic findByCustomerId(Long customerId) {
        return customerFortuneStatisticMapper.findByCustomerId(customerId);
    }

    @Override
    public void update(AclCustomerFortuneStatistic statistic) {
        customerFortuneStatisticMapper.updateByPrimaryKeySelective(statistic);
    }
}
