package com.yd.dal.service.customer.impl;

import com.yd.dal.entity.customer.AclCustomerFortunePayoutBatch;
import com.yd.dal.mapper.customer.AclCustomerFortunePayoutBatchMapper;
import com.yd.dal.service.customer.AclCustomerFortunePayoutBatchDALService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xxy
 */
@Service("aclCustomerFortunePayoutBatchDALService")
public class AclCustomerFortunePayoutBatchDALServiceImpl implements AclCustomerFortunePayoutBatchDALService {

    @Autowired
    private AclCustomerFortunePayoutBatchMapper customerFortunePayoutBatchMapper;

    @Override
    public AclCustomerFortunePayoutBatch findByPayoutYearmonth(String payoutYearmonth) {
        return customerFortunePayoutBatchMapper.selectByPayoutYearmonth(payoutYearmonth);
    }

    @Override
    public void save(AclCustomerFortunePayoutBatch customerFortunePayoutBatch) {
        customerFortunePayoutBatchMapper.insert(customerFortunePayoutBatch);
    }

    @Override
    public List<String> findAll() {
        return customerFortunePayoutBatchMapper.selectAll();
    }
}
