package com.yd.dal.entity.product;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * ag_product_plan
 * @author 
 */
@Data
public class ProductPlan implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_insurer.id
     */
    private Long insurerId;

    /**
     * FK ag_product.id
     */
    private Long productId;

    /**
     * plan#= plan code
     */
    private String planCode;

    /**
     * contract_id for Starr; Risk-Duty code for Fosun
     */
    private String contractId;

    /**
     * plan Chinese name
     */
    private String name;

    /**
     * plan Level name 档次显示
     */
    private String nameSub;

    /**
     * plan Eng name
     */
    private String nameEn;

    /**
     * 0, 1=low, 2=mid 3=high, 4=super
     */
    private Integer level;

    private BigDecimal commisionRate;

    private BigDecimal referralRate;

    private BigDecimal salePrice;

    /**
     * 0000-00-00
     */
    private Date effectiveStartDate;

    /**
     * 0000-00-00
     */
    private Date effectiveEndDate;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 0=No, 1=Yes
     */
    private Integer isGlobal;

    /**
     * FK ag_acl_continent.id
     */
    private Long continentId;

    /**
     * FK ag_md_country.id
     */
    private Long countryId;

    /**
     * FK ag_md_region.id
     */
    private Long regionId;

    /**
     * 0=No, 1=Yes
     */
    private Integer isPopular;

    /**
     * incremental +1
     */
    private Integer salesCount;

    /**
     * version control
     */
    private Integer version;

    /**
     * 支持社保类型(1-仅支持有社保; 0-仅支持无社保; 3-同时支持有、无社保)
     */
    private Integer isSocialInsured;

    /**
     * 适用性别(1-男;2-女)
     */
    private Integer appGender;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    /**
     * 修改人
     */
    private Long updatedBy;

    private static final long serialVersionUID = 1L;
}