package com.yd.dal.entity.meta;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 个人所得税预扣率表（居民个人工资、薪金所得预扣预缴适用）
 * @author xxy
 */
@Data
public class MdIncometaxRate implements Serializable {
    /**
    * serial id
    */
    private Long id;

    /**
    * 级数
    */
    private Integer taxLevel;

    /**
    * 累计预扣预缴应纳税所得额 from
    */
    private BigDecimal taxableFrom;

    /**
    * 累计预扣预缴应纳税所得额 to
    */
    private BigDecimal taxableTo;

    /**
    * 预扣率（%）
    */
    private Integer taxRate;

    /**
    * 速算扣除数
    */
    private BigDecimal estDeductable;

    /**
    * 建置日
    */
    private Date createdAt;

    /**
    * 建置者
    */
    private Long createdBy;

    /**
    * 更新日
    */
    private Date updatedAt;

    /**
    * 更新者
    */
    private Long updatedBy;
}