package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_practitioner_potential_goals
 * @author 
 */
@Data
public class AclPractitionerPotentialGoals implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_practitioner.id 经纪人
     */
    private Long practitionerId;

    /**
     * 目标所属年度
     */
    private Integer currentYear;

    /**
     * 1:年度，2：季度，3：月度
     */
    private Integer statisticTimeUnit;

    /**
     * 1：年度，3：月度
     */
    private Integer seqTime;

    /**
     * 招聘增员数
     */
    private Integer numberRecruits;

    /**
     * 百万圆桌成员数
     */
    private Integer numberMdrt;

    /**
     * 版本控制
     */
    private Date currentVersion;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    private Long updatedBy;

    private static final long serialVersionUID = 1L;
}