package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_practitioner_potential_assigneds
 * @author 
 */
@Data
public class AclPractitionerPotentialAssigneds implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * 经纪人id
     */
    private Long assignedPractitionerId;

    /**
     * FK ag_acl_practitioner_potential.id潜在经纪人表id
     */
    private Long practitionerPotentialId;

    /**
     * 预计报聘时间
     */
    private Date timeToOnboarding;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 分析建置时间
     */
    private Date createdAt;

    /**
     * 建置者 FK ag_acl_user.id
     */
    private Long createdBy;

    /**
     * 更新时间
     */
    private Date updatedAt;

    /**
     * 更新者 FK ag_acl_user.id
     */
    private Long updatedBy;

    /**
     * 更新者类型:1为user id（AGMS），2为本人practitioner id（银盾经纪）
     */
    private Integer updaterType;

    /**
     * 创建者类型:1为user id（AGMS），2为本人practitioner id（银盾经纪）
     */
    private Integer creatorType;
    /**
     * 备注
     */
    private String remark;

    private static final long serialVersionUID = 1L;
}