package com.yd.api.market.service.impl;

import com.yd.api.market.service.MarketService;
import com.yd.api.market.vo.announcement.AnnouncementInfo;
import com.yd.api.market.vo.announcement.AnnouncementQueryRequestVO;
import com.yd.api.market.vo.announcement.AnnouncementQueryResponseVO;
import com.yd.api.market.vo.poster.PosterQueryRequestVO;
import com.yd.api.market.vo.poster.PosterQueryResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclPractitioner;
import com.yd.dal.entity.marketing.MktAnnouncement;
import com.yd.dal.entity.marketing.PosterInfo;
import com.yd.dal.entity.meta.MdDropOptions;
import com.yd.dal.service.customer.AclPractitionerDALService;
import com.yd.dal.service.marketing.MarketDALService;
import com.yd.dal.service.marketing.MktAnnouncementDALService;
import com.yd.dal.service.meta.MdDropOptionsDALService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service("marketService")
public class MarketServiceImpl implements MarketService {

    @Autowired
    private MktAnnouncementDALService mktAnnouncementDALService;
    @Autowired
    private MdDropOptionsDALService mdDropOptionsDALService;
    @Autowired
    private AclPractitionerDALService aclPractitionerDALService;
    @Autowired
    private MarketDALService marketDALService;

    @Override
    public AnnouncementQueryResponseVO announcementQuery(AnnouncementQueryRequestVO requestVO) {
        AnnouncementQueryResponseVO responseVO = new AnnouncementQueryResponseVO();
        Long id = requestVO.getId(),announcementType = requestVO.getAnnouncementTypeId();
        List<MktAnnouncement> announcementList = new ArrayList<>();
        //根据条件查询出相关的数据
        if(id != null){
            MktAnnouncement announcement = mktAnnouncementDALService.findById(id);
            announcementList.add(announcement);
        }else if(announcementType != null){
            announcementList = mktAnnouncementDALService.findByType(announcementType);
        }else{
            announcementList = mktAnnouncementDALService.findByIsActiveAndAnnouncementAtBefore(1,new Date());
        }
        if(!announcementList.isEmpty()){
            List<MdDropOptions> options = mdDropOptionsDALService.findByDropMasterCode("yd_mkt_announcement_type");
            Map<Long,MdDropOptions> optionsMap = new HashMap<>();
            options.forEach(i-> optionsMap.put(i.getId(),i));
            List<AnnouncementInfo> announcementInfoList = new ArrayList<>();
            MdDropOptions dropOptions;
            AnnouncementInfo announcementInfo;
            for(MktAnnouncement item : announcementList){
                announcementInfo = new AnnouncementInfo();
                BeanUtils.copyProperties(item,announcementInfo);
                announcementType = item.getAnnouncementType();
                if(announcementType != null){
                    dropOptions = optionsMap.get(announcementType);
                    if(dropOptions != null){
                        announcementInfo.setAnnouncementTypeName(dropOptions.getDropOptionName());
                    }
                }
                announcementInfo.setAnnouncementAt(CommonUtil.dateParseString(item.getAnnouncementAt(),"yyyy-MM-dd"));
                announcementInfo.setCreatedAt(CommonUtil.dateParseString(item.getCreatedAt(),"yyyy-MM-dd HH:mm:ss"));
                announcementInfoList.add(announcementInfo);
            }
            responseVO.setAnnouncementInfoList(announcementInfoList);
            responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        }else{
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("810039")));
        }
        return responseVO;
    }

    @Override
    public PosterQueryResponseVO posterQuery(PosterQueryRequestVO requestVO) {
        PosterQueryResponseVO responseVO = new PosterQueryResponseVO();
        Long practitionerId = requestVO.getPractitionerId();
        AclPractitioner practitioner = aclPractitionerDALService.findPractitionerById(practitionerId);
        responseVO.setIsNameShow(practitioner.getIsNameShow());
        responseVO.setIsMobileShow(practitioner.getIsMobileShow());
        Long mdDropOptionId = requestVO.getMdDropOptionId();
        List<PosterInfo> posterInfos = marketDALService.posterQuery(mdDropOptionId);
        responseVO.setPosterInfos(posterInfos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }
}
