package com.yd.dataccess.service.mkt;

import com.yd.dataccess.entity.mkt.MktAnnouncement;
import com.yd.dataccess.mapper.mkt.MktAnnouncementMapper;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
/**
 * @Transactional class level transaction管理
 * @author Simon
 * @version 1.0
 */
@Service("mktAnnouncementServiceDAImpl")
@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
public class MktAnnouncementServiceDAImpl implements MktAnnouncementServiceDA {
    @Resource
    private MktAnnouncementMapper mktAnnouncementMapper;

	@Override
	@TargetDataSource(dataSourceKey = DataSourceKey.DB_MASTER)
	public List<MktAnnouncement> findByType(Long announcementType) {
    	List<MktAnnouncement> destList = new ArrayList<MktAnnouncement>();

        destList = mktAnnouncementMapper.findByType(announcementType);

        return destList;
	}

	@Override
	public List<MktAnnouncement> findByIsActive(Integer isActive) {
    	List<MktAnnouncement> destList = new ArrayList<MktAnnouncement>();

        destList = mktAnnouncementMapper.findByIsActive(isActive);

        return destList;
	}

	@Override
	public List<MktAnnouncement> findByIsActiveAndAnnouncementAtBefore(int isActive, Date announcementAt) {
    	List<MktAnnouncement> destList = new ArrayList<MktAnnouncement>();

        destList = mktAnnouncementMapper.findByIsActiveAndAnnouncementAtBefore(isActive,announcementAt);

        return destList;
	}

	/*
	 * 查询记录
	 * (non-Javadoc)
	 * @see com.yd.dataccess.service.mkt.MktAnnouncementServiceDA#findBySeqAndIsActive(java.lang.Integer, java.lang.Integer)
	 */
	@Override
	public List<MktAnnouncement> findBySeqAndIsActive(Integer seq, Integer isActive) {
    	List<MktAnnouncement> destList = new ArrayList<MktAnnouncement>();

        destList = mktAnnouncementMapper.findBySeqAndIsActive(seq,isActive);

        return destList;
	}

	/*
	 * add添加一条记录
	 * @Transactional method level transaction管理
	 * (non-Javadoc)
	 * @see com.yd.dataccess.service.mkt.MktAnnouncementServiceDA#insert(com.yd.dataccess.entity.mkt.MktAnnouncement)
	 */
	@Override
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public MktAnnouncement insert(MktAnnouncement mktAnnouncement) {
		mktAnnouncementMapper.insert(mktAnnouncement);
		return mktAnnouncement;
	}
	/*
	 * update修改一条记录
	 * (non-Javadoc)
	 * @see com.yd.dataccess.service.mkt.MktAnnouncementServiceDA#update(com.yd.dataccess.entity.mkt.MktAnnouncement)
	 */
	@Override
	public int update(MktAnnouncement mktAnnouncement) {
		int result = mktAnnouncementMapper.update(mktAnnouncement);
		return result;
	}
	/*
	 * delete删除一条记录
	 * (non-Javadoc)
	 * @see com.yd.dataccess.service.mkt.MktAnnouncementServiceDA#delete(java.lang.Long)
	 */
	@Override
	public int delete(Long announcementType) {
		int result = mktAnnouncementMapper.delete(announcementType);
		return result;
	}	
}