package com.yd.api.agms.service.impl;

import com.github.pagehelper.PageInfo;
import com.yd.api.agms.service.AgmsStatementService;
import com.yd.api.agms.vo.statement.FinancialStatementRequestVO;
import com.yd.api.agms.vo.statement.FinancialStatementResponseVO;
import com.yd.api.agms.vo.statement.statementData;
import com.yd.api.commission.service.CommissionService;
import com.yd.api.result.CommonResult;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;

@Service("agmsStatementService")
public class AgmsStatementServiceImpl implements AgmsStatementService {
    @Autowired
    private CommissionService commissionService;
    @Override
    public FinancialStatementResponseVO financialPredictStatement(FinancialStatementRequestVO requestVO, HttpServletResponse response) {
        FinancialStatementResponseVO responseVO = new FinancialStatementResponseVO();
        PageInfo<statementData> pageInfo = requestVO.getPageInfo();
        String inCommissionTime = requestVO.getInCommissionTime();//来佣时间
        String outCommissionTime = requestVO.getOutCommissionTime();//发佣时间
        inCommissionTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(inCommissionTime,"yyyy-MM-dd HH:mm:ss"),"yyyyMM");
        outCommissionTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(outCommissionTime,"yyyy-MM-dd HH:mm:ss"),"yyyyMM");
        String insurerBranchId = requestVO.getInsurerBranchId();//分公司
        String deptId = requestVO.getDeptId();//营业部
        String subordinateId = requestVO.getSubordinateId();//体系
        Integer type = requestVO.getType();
        Integer isStatement = requestVO.getIsStatement();
        PageInfo<statementData> dataList = commissionService.getStatementDataByPage(pageInfo.getPageNum(),pageInfo.getSize(),isStatement,type, inCommissionTime, outCommissionTime,insurerBranchId,deptId,subordinateId);
        responseVO.setPredictStatementDataList(dataList);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }
}
