package com.yd.dal.service.marketing.Impl;

import com.yd.dal.entity.marketing.MktLeadsAssigneds;
import com.yd.dal.mapper.marketing.MktLeadsAssignedsMapper;
import com.yd.dal.service.marketing.MktLeadsAssignedsDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

@Service("mktLeadsAssignedsDALService")
public class MktLeadsAssignedsDALServiceImpl implements MktLeadsAssignedsDALService {
    @Resource
    private MktLeadsAssignedsMapper mktLeadsAssignedsMapper;

    @Override
    public List<MktLeadsAssigneds> findByMktLeadsAssigneds(MktLeadsAssigneds mktLeadsAssigneds) {
        return mktLeadsAssignedsMapper.findByMktLeadsAssigneds(mktLeadsAssigneds);
    }

    @Override
    public MktLeadsAssigneds findByLeadsAssignedId(Long leadsAssignedId) {
        return mktLeadsAssignedsMapper.selectByPrimaryKey(leadsAssignedId);
    }

    @Override
    public void updateMktLeadsAssigneds(MktLeadsAssigneds mktLeadsAssigneds) {
        mktLeadsAssignedsMapper.updateByPrimaryKeySelective(mktLeadsAssigneds);
    }

    @Override
    public void save(MktLeadsAssigneds assigneds) {
        mktLeadsAssignedsMapper.insertSelective(assigneds);
    }

    @Override
    public List<MktLeadsAssigneds> findByPractitionerIdAndThisWeek(Long practitionerId) {
        return mktLeadsAssignedsMapper.findByPractitionerIdAndThisWeek(practitionerId);
    }

    @Override
    public Integer countPractitionerIdsAndThisWeek(List<Long> practitionerIds) {
        return mktLeadsAssignedsMapper.countPractitionerIdsAndThisWeek(practitionerIds);
    }

    @Override
    public HashMap<String, BigDecimal> performanceForecastForTeam(List<Long> practitionerIds,Long refusedId) {
        return mktLeadsAssignedsMapper.performanceForecastForTeam(practitionerIds,refusedId);
    }
}
