package com.yd.api.practitioner.service.impl;

import com.yd.api.practitioner.service.PractitionerHiringService;
import com.yd.api.practitioner.vo.hiring.*;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclPractitionerHiringBasicInfo;
import com.yd.dal.entity.customer.AclPractitionerHiringMembership;
import com.yd.dal.mapper.customer.AclPractitionerHiringBasicInfoMapper;
import com.yd.dal.mapper.customer.AclPractitionerHiringMembershipMapper;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;


@Service
public class PractitionerHiringServiceImpl implements PractitionerHiringService {

    @Autowired
    private AclPractitionerHiringMembershipMapper membershipMapper;
    @Autowired
    private AclPractitionerHiringBasicInfoMapper basicInfoMapper;

    @Override
    public SaveMembershipResponseVO saveMembership(SaveMembershipRequestVO requestVO) {
        SaveMembershipResponseVO resp = new SaveMembershipResponseVO();
        try {
            // 先保存ag_acl_practitioner_hiring_basic_info，获取hiringBasicInfoId
            AclPractitionerHiringBasicInfo basicInfo = new AclPractitionerHiringBasicInfo();
            basicInfo.setName(requestVO.getName());
            basicInfo.setPractitionerPotentialId(requestVO.getPractitionerPotentialId());
            basicInfoMapper.insertSelective(basicInfo);
            System.out.println("看看主键回写");
            System.out.println(basicInfo);
            // 数据库实体
            AclPractitionerHiringMembership membership = new AclPractitionerHiringMembership();
            BeanUtils.copyProperties(requestVO, membership);
            membership.setIsActive(1);

            Date curDate = new Date();
            membership.setCreatedAt(curDate);
            membership.setUpdatedAt(curDate);

            Long loginId = requestVO.getLoginId();
            membership.setCreatedBy(loginId);
            membership.setUpdatedBy(loginId);

            membershipMapper.insertSelective(membership);

            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }

    @Override
    public SaveBasicInfoResponseVO saveBasicInfo(SaveBasicInfoRequestVO requestVO) {
        SaveBasicInfoResponseVO resp = new SaveBasicInfoResponseVO();
        try {
            // 数据库实体
            AclPractitionerHiringBasicInfo basicInfo = new AclPractitionerHiringBasicInfo();
            BeanUtils.copyProperties(requestVO, basicInfo);
            basicInfo.setIsActive(1);

            Date curDate = new Date();
            basicInfo.setCreatedAt(curDate);
            basicInfo.setUpdatedAt(curDate);

            basicInfo.setCreatedBy(Long.valueOf(-1));
            basicInfo.setUpdatedBy(Long.valueOf(-1));

            basicInfoMapper.updateByPractitionerPotentialId(basicInfo);

            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }
}
