package com.yd.api.practitioner;


import com.yd.api.practitioner.service.PractitionerHiringService;
import com.yd.api.practitioner.vo.hiring.*;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 经纪人报聘
 */
@RestController
@RequestMapping("/practitionerHiring")
public class PractitionerHiringController {
	
	@Autowired
	private PractitionerHiringService practitionerHiringService;

	/**
	 * 保存报聘经纪人组织关系
	 *
	 */
	@RequestMapping("/saveMembership")
	public Object saveMembership(@RequestBody SaveMembershipRequestVO requestVO){
		JsonResult result = new JsonResult();
		SaveMembershipResponseVO responseVO = practitionerHiringService.saveMembership(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人基本信息
	 *
	 */
	@RequestMapping("/saveBasicInfo")
	public Object saveBasicInfo(@RequestBody SaveBasicInfoRequestVO requestVO){
		JsonResult result = new JsonResult();
		SaveBasicInfoResponseVO responseVO = practitionerHiringService.saveBasicInfo(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}



}