package com.yd.dal.entity.marketing;

import java.util.Date;
import lombok.Data;

/**
    * 银盾公告
    */
@Data
public class MktAnnouncement {
    /**
    * serial id
    */
    private Long id;

    /**
    * 保险公司ID, FK ag_acl_insurer.id
    */
    private Long insurerId;

    /**
    * 保险分支机构ID, FK ag_acl_insurer_branch.id
    */
    private Long insurerBranchId;

    /**
    * 公告标题
    */
    private String title;

    /**
    * 公告内容
    */
    private String content;

    /**
    * FK ag_md_drop_options.id 1=运营公告 2=市场喜讯 3重要通知，4新品上架，5竞赛奖励
    */
    private Long announcementType;

    /**
    * 发布时间
    */
    private Date announcementAt;

    /**
    * listed sequence
    */
    private Integer seq;

    /**
    * 0=No, 1=Yes
    */
    private Integer isActive;

    private Date createdAt;

    private Long createdBy;
}