/*
 * Decompiled with CFR 0.152.
 */
package com.libs.pdf.freemarker;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.XMLWorkerFontProvider;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.html.CssAppliersImpl;
import com.itextpdf.tool.xml.html.Tags;
import com.itextpdf.tool.xml.net.FileRetrieve;
import com.itextpdf.tool.xml.net.ReadingProcessor;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.parser.XMLParserListener;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import com.itextpdf.tool.xml.pipeline.html.AbstractImageProvider;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.pipeline.html.ImageProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PdfGenerator {
    public static void generate(String htmlStr, OutputStream out) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        org.w3c.dom.Document doc = builder.parse(new ByteArrayInputStream(htmlStr.getBytes()));
        ITextRenderer renderer = new ITextRenderer();
        renderer.setDocument(doc, null);
        renderer.layout();
        renderer.createPDF(out);
        out.close();
    }

    public static void generatePlus(String htmlStr, OutputStream out) throws IOException, DocumentException {
        String charsetName = "UTF-8";
        Document document = new Document(PageSize.A4, 30.0f, 30.0f, 30.0f, 30.0f);
        document.setMargins(30.0f, 30.0f, 30.0f, 30.0f);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
        document.open();
        HtmlPipelineContext htmlContext = new HtmlPipelineContext((CssAppliers)new CssAppliersImpl((FontProvider)new XMLWorkerFontProvider(){

            public Font getFont(String fontname, String encoding, float size, int style) {
                if (fontname == null) {
                    fontname = "SimSun";
                }
                return super.getFont(fontname, encoding, size, style);
            }
        })){

            public HtmlPipelineContext clone() throws CloneNotSupportedException {
                HtmlPipelineContext context = super.clone();
                ImageProvider imageProvider = this.getImageProvider();
                context.setImageProvider(imageProvider);
                return context;
            }
        };
        htmlContext.setImageProvider((ImageProvider)new AbstractImageProvider(){
            String rootPath = PdfGenerator.class.getResource("/").getPath();

            public String getImageRootPath() {
                return this.rootPath;
            }

            public Image retrieve(String src) {
                if (StringUtils.isEmpty((CharSequence)src)) {
                    return null;
                }
                try {
                    Image image = Image.getInstance((String)new File(this.rootPath, src).toURI().toString());
                    image.setAbsolutePosition(400.0f, 400.0f);
                    if (image != null) {
                        this.store(src, image);
                        return image;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return super.retrieve(src);
            }
        });
        htmlContext.setAcceptUnknown(true).autoBookmark(true).setTagFactory(Tags.getHtmlTagProcessorFactory());
        CSSResolver cssResolver = XMLWorkerHelper.getInstance().getDefaultCssResolver(true);
        cssResolver.setFileRetrieve(new FileRetrieve(){

            public void processFromStream(InputStream in, ReadingProcessor processor) throws IOException {
                InputStreamReader reader = new InputStreamReader(in, "UTF-8");
                try {
                    int i = -1;
                    while (-1 != (i = reader.read())) {
                        processor.process(i);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            public void processFromHref(String href, ReadingProcessor processor) throws IOException {
                InputStream is = PdfGenerator.class.getResourceAsStream("/" + href);
                InputStreamReader reader = new InputStreamReader(is, "UTF-8");
                try {
                    int i = -1;
                    while (-1 != (i = reader.read())) {
                        processor.process(i);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        HtmlPipeline htmlPipeline = new HtmlPipeline(htmlContext, (Pipeline)new PdfWriterPipeline(document, writer));
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, (Pipeline)htmlPipeline);
        XMLWorker worker = null;
        worker = new XMLWorker((Pipeline)pipeline, true);
        XMLParser parser = new XMLParser(true, (XMLParserListener)worker, Charset.forName("UTF-8"));
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(htmlStr.getBytes("utf-8"));
            parser.parse((InputStream)inputStream, Charset.forName("UTF-8"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        document.close();
    }
}

