package com.yd.dal.service.order;

import com.yd.dal.entity.order.CustomerPolicyInfo;
import com.yd.dal.entity.order.PoOrder;
import com.yd.dal.entity.order.PolicyDetailInfoE;
import com.yd.dal.entity.order.PolicyFactorInfoE;

import java.util.List;

public interface PoOrderDALService {
    List<PoOrder> findByStatusAndShareCodeInGroupByCustomerId(int status, List<String> customerShareCodes);

    PoOrder findByOrderId(Long orderId);

    List<CustomerPolicyInfo> findPolicyInfoByCustomerId(Long customerId, Integer time);

    List<CustomerPolicyInfo> findPolicyInfoByMobileNoE(String mobileNo, Integer time);

    String findOrderNoByPolicyNo(String policyNo);

    List<PolicyDetailInfoE> findPolicyDetailsInfoByOrderNoE(String orderNo);

    List<PolicyFactorInfoE> findPolicyFactorByOrderNosE(List<String> orderNoList);

    PoOrder findByIdAndStatus(Long orderId, int status);

    void update(PoOrder poOrder);

    List<PoOrder> findByIds(List<Long> orderIds);

    List<Long> findVehiclePolicyInfoByCustomerId(Long customerId);
}
