package com.yd.dal.entity.customer;

import lombok.Data;

import java.util.Date;

/**
    * 報聘经纪人组织关系表
    */
@Data
public class AclPractitionerHiringMembership {
    /**
    * serial id
    */
    private Long id;

    /**
    * FK ag_acl_practitioner_hiring_basic_info.id
    */
    private Long hiringBasicInfoId;

    /**
    * 報聘经纪人职级类型 FK ag_md_drop_options.id: ag_md_drop_master.scenario_code = "practitioner_level"
    */
    private Long mdDropOptionId;

    /**
    * 報聘经纪人职级类型 FK ag_md_drop_options.id: ag_md_drop_master.scenario_code = "practitioner_level"
    */
    private String mdDropOptionName;

    /**
    * 辅导人id
    */
    private Long mentorPractitionerId;

    /**
    * 辅导人
    */
    private String mentor;

    /**
    * 介绍人id
    */
    private Long introducerPractitionerId;

    /**
    * 介绍人
    */
    private String introducer;

    /**
    * 体系id
    */
    private Long subsystemId;

    /**
    * 体系
    */
    private String subsystem;

    /**
    * 体系负责人_practitioner_id
    */
    private Long subsystemOwnerId;

    /**
    * 体系负责人
    */
    private String subsystemOwner;

    /**
    * 分公司id
    */
    private Long branchId;

    /**
    * 分公司
    */
    private String branch;

    /**
    * 0=No, 1=Yes
    */
    private Integer isActive;

    /**
    * 建置日
    */
    private Date createdAt;

    /**
    * 建置者
    */
    private Long createdBy;

    /**
    * 更新日
    */
    private Date updatedAt;

    private Long updatedBy;

    private Long approvedBy;

    /**
     * 辅导人的组织架构信息
     */
    private String systemFlag;//系统标志，区分公司营业部和体系，1，分公司，2营业部，3，S1分部,4,S2体系,5,S3纵队
    private String s3SubordinateSystemName;//s3所属体系名称
    private String s2SubordinateSystemName;//s2所属体系名称
    private String s1SubordinateSystemName;//s1所属体系名称
    private String s3TeamLeaderName;//S3团队长名称
    private String s2TeamLeaderName;//S2团队长名称
    private String s1TeamLeaderName;//S1团队长名称
    private Long s3TeamLeaderId;//S3团队长Id
    private Long s2TeamLeaderId;//S2团队长Id
    private Long s1TeamLeaderId;//S1团队长Id
}