package com.yd.api.agms.vo.sharing;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.List;

/**
 * @author xxy
 */
@JsonInclude(value= JsonInclude.Include.NON_DEFAULT )
public class ControllerResponseVO {

    private String state;

    private String url;

    private String title;

    private String original;

    private String type;

    private Long size;
    /** 执行上传图片的action名称 */
    private String imageActionName;
    /** 提交的图片表单名称 */
    private String imageFieldName;
    /** 上传大小限制，单位B */
    private int imageMaxSize;
    /** 上传图片格式显示 */
    private List<String> imageAllowFiles;
    /** 是否压缩图片,默认是true */
    private boolean imageCompressEnable;
    /** 图片压缩最长边限制 */
    private int imageCompressBorder;
    /** 插入的图片浮动方式 */
    private String imageInsertAlign;
    /** 图片访问路径前缀 */
    private String imageUrlPrefix;
    /** 上传保存路径,可以自定义保存路径和文件名格式 */
    private String imagePathFormat;
    /** 执行上传涂鸦的action名称 */
    private String scrawlActionName;
    /** 提交的图片表单名称 */
    private String scrawlFieldName;
    /** 上传保存路径,可以自定义保存路径和文件名格式 */
    private String scrawlPathFormat;
    /** 上传大小限制，单位B */
    private int scrawlMaxSize;
    /** 图片访问路径前缀 */
    private String scrawlUrlPrefix;
    /** 执行上传截图的action名称 */
    private String scrawlInsertAlign;
    /** 上传保存路径,可以自定义保存路径和文件名格式 */
    private String snapscreenActionName;
    /** 图片访问路径前缀 */
    private String snapscreenPathFormat;
    /** 插入的图片浮动方式 */
    private String snapscreenUrlPrefix;

    private String snapscreenInsertAlign;
    /** 抓取远程图片配置 */
    private List<String> catcherLocalDomain;
    /** 执行抓取远程图片的action名称 */
    private String catcherActionName;
    /** 提交的图片列表表单名称 */
    private String catcherFieldName;
    /** 上传保存路径,可以自定义保存路径和文件名格式 */
    private String catcherPathFormat;
    /** 图片访问路径前缀 */
    private String catcherUrlPrefix;
    /** 上传大小限制，单位B */
    private int catcherMaxSize;
    /** 抓取图片格式显示 */
    private List<String> catcherAllowFiles;
    /** 执行上传视频的action名称 */
    private String videoActionName;
    /** 提交的视频表单名称 */
    private String videoFieldName;

    private String videoPathFormat;
    /** 视频访问路径前缀 */
    private String videoUrlPrefix;
    /** 上传大小限制，单位B，默认100MB */
    private int videoMaxSize;
    /** 上传视频格式显示 */
    private List<String> videoAllowFiles;
    /** controller里,执行上传视频的action名称 */
    private String fileActionName;
    /** 提交的文件表单名称 */
    private String fileFieldName;
    /** 上传保存路径,可以自定义保存路径和文件名格式 */
    private String filePathFormat;
    /** 文件访问路径前缀 */
    private String fileUrlPrefix;
    /** 上传大小限制，单位B，默认50MB */
    private int fileMaxSize;
    /** 上传文件格式显示 */
    private List<String> fileAllowFiles;
    /** 执行图片管理的action名称 */
    private String imageManagerActionName;
    /** 指定要列出图片的目录 */
    private String imageManagerListPath;
    /** 每次列出文件数量 */
    private int imageManagerListSize;
    /** 图片访问路径前缀 */
    private String imageManagerUrlPrefix;
    /** 插入的图片浮动方式 */
    private String imageManagerInsertAlign;
    /** 列出的文件类型 */
    private List<String> imageManagerAllowFiles;
    /** 执行文件管理的action名称 */
    private String fileManagerActionName;
    /** 指定要列出文件的目录 */
    private String fileManagerListPath;
    /** 文件访问路径前缀 */
    private String fileManagerUrlPrefix;
    /** 每次列出文件数量 */
    private int fileManagerListSize;
    /** 列出的文件类型 */
    private List<String> fileManagerAllowFiles;

    /**
     * 获取
     *
     * @return the state
     */
    public String getState() {
        return this.state;
    }

    /**
     * 设置
     *
     * @param state the  to set
     */
    public void setState(String state) {
        this.state = state;
    }

    /**
     * 获取
     *
     * @return the url
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * 设置
     *
     * @param url the  to set
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * 获取
     *
     * @return the title
     */
    public String getTitle() {
        return this.title;
    }

    /**
     * 设置
     *
     * @param title the  to set
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * 获取
     *
     * @return the original
     */
    public String getOriginal() {
        return this.original;
    }

    /**
     * 设置
     *
     * @param original the  to set
     */
    public void setOriginal(String original) {
        this.original = original;
    }

    /**
     * 获取
     *
     * @return the type
     */
    public String getType() {
        return this.type;
    }

    /**
     * 设置
     *
     * @param type the  to set
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 获取
     *
     * @return the size
     */
    public Long getSize() {
        return this.size;
    }

    /**
     * 设置
     *
     * @param size the  to set
     */
    public void setSize(Long size) {
        this.size = size;
    }

    /**
     * 获取 执行上传图片的action名称
     *
     * @return the imageActionName 执行上传图片的action名称
     */
    public String getImageActionName() {
        return this.imageActionName;
    }

    /**
     * 设置 执行上传图片的action名称
     *
     * @param imageActionName the 执行上传图片的action名称 to set
     */
    public void setImageActionName(String imageActionName) {
        this.imageActionName = imageActionName;
    }

    /**
     * 获取 提交的图片表单名称
     *
     * @return the imageFieldName 提交的图片表单名称
     */
    public String getImageFieldName() {
        return this.imageFieldName;
    }

    /**
     * 设置 提交的图片表单名称
     *
     * @param imageFieldName the 提交的图片表单名称 to set
     */
    public void setImageFieldName(String imageFieldName) {
        this.imageFieldName = imageFieldName;
    }

    /**
     * 获取 上传大小限制，单位B
     *
     * @return the imageMaxSize 上传大小限制，单位B
     */
    public int getImageMaxSize() {
        return this.imageMaxSize;
    }

    /**
     * 设置 上传大小限制，单位B
     *
     * @param imageMaxSize the 上传大小限制，单位B to set
     */
    public void setImageMaxSize(int imageMaxSize) {
        this.imageMaxSize = imageMaxSize;
    }

    /**
     * 获取 上传图片格式显示
     *
     * @return the imageAllowFiles 上传图片格式显示
     */
    public List<String> getImageAllowFiles() {
        return this.imageAllowFiles;
    }

    /**
     * 设置 上传图片格式显示
     *
     * @param imageAllowFiles the 上传图片格式显示 to set
     */
    public void setImageAllowFiles(List<String> imageAllowFiles) {
        this.imageAllowFiles = imageAllowFiles;
    }

    /**
     * 获取 是否压缩图片默认是true
     *
     * @return the imageCompressEnable 是否压缩图片默认是true
     */
    public boolean isImageCompressEnable() {
        return this.imageCompressEnable;
    }

    /**
     * 设置 是否压缩图片默认是true
     *
     * @param imageCompressEnable the 是否压缩图片默认是true to set
     */
    public void setImageCompressEnable(boolean imageCompressEnable) {
        this.imageCompressEnable = imageCompressEnable;
    }

    /**
     * 获取 图片压缩最长边限制
     *
     * @return the imageCompressBorder 图片压缩最长边限制
     */
    public int getImageCompressBorder() {
        return this.imageCompressBorder;
    }

    /**
     * 设置 图片压缩最长边限制
     *
     * @param imageCompressBorder the 图片压缩最长边限制 to set
     */
    public void setImageCompressBorder(int imageCompressBorder) {
        this.imageCompressBorder = imageCompressBorder;
    }

    /**
     * 获取 插入的图片浮动方式
     *
     * @return the imageInsertAlign 插入的图片浮动方式
     */
    public String getImageInsertAlign() {
        return this.imageInsertAlign;
    }

    /**
     * 设置 插入的图片浮动方式
     *
     * @param imageInsertAlign the 插入的图片浮动方式 to set
     */
    public void setImageInsertAlign(String imageInsertAlign) {
        this.imageInsertAlign = imageInsertAlign;
    }

    /**
     * 获取 图片访问路径前缀
     *
     * @return the imageUrlPrefix 图片访问路径前缀
     */
    public String getImageUrlPrefix() {
        return this.imageUrlPrefix;
    }

    /**
     * 设置 图片访问路径前缀
     *
     * @param imageUrlPrefix the 图片访问路径前缀 to set
     */
    public void setImageUrlPrefix(String imageUrlPrefix) {
        this.imageUrlPrefix = imageUrlPrefix;
    }

    /**
     * 获取 上传保存路径可以自定义保存路径和文件名格式
     *
     * @return the imagePathFormat 上传保存路径可以自定义保存路径和文件名格式
     */
    public String getImagePathFormat() {
        return this.imagePathFormat;
    }

    /**
     * 设置 上传保存路径可以自定义保存路径和文件名格式
     *
     * @param imagePathFormat the 上传保存路径可以自定义保存路径和文件名格式 to set
     */
    public void setImagePathFormat(String imagePathFormat) {
        this.imagePathFormat = imagePathFormat;
    }

    /**
     * 获取 执行上传涂鸦的action名称
     *
     * @return the scrawlActionName 执行上传涂鸦的action名称
     */
    public String getScrawlActionName() {
        return this.scrawlActionName;
    }

    /**
     * 设置 执行上传涂鸦的action名称
     *
     * @param scrawlActionName the 执行上传涂鸦的action名称 to set
     */
    public void setScrawlActionName(String scrawlActionName) {
        this.scrawlActionName = scrawlActionName;
    }

    /**
     * 获取 提交的图片表单名称
     *
     * @return the scrawlFieldName 提交的图片表单名称
     */
    public String getScrawlFieldName() {
        return this.scrawlFieldName;
    }

    /**
     * 设置 提交的图片表单名称
     *
     * @param scrawlFieldName the 提交的图片表单名称 to set
     */
    public void setScrawlFieldName(String scrawlFieldName) {
        this.scrawlFieldName = scrawlFieldName;
    }

    /**
     * 获取 上传保存路径可以自定义保存路径和文件名格式
     *
     * @return the scrawlPathFormat 上传保存路径可以自定义保存路径和文件名格式
     */
    public String getScrawlPathFormat() {
        return this.scrawlPathFormat;
    }

    /**
     * 设置 上传保存路径可以自定义保存路径和文件名格式
     *
     * @param scrawlPathFormat the 上传保存路径可以自定义保存路径和文件名格式 to set
     */
    public void setScrawlPathFormat(String scrawlPathFormat) {
        this.scrawlPathFormat = scrawlPathFormat;
    }

    /**
     * 获取 上传大小限制，单位B
     *
     * @return the scrawlMaxSize 上传大小限制，单位B
     */
    public int getScrawlMaxSize() {
        return this.scrawlMaxSize;
    }

    /**
     * 设置 上传大小限制，单位B
     *
     * @param scrawlMaxSize the 上传大小限制，单位B to set
     */
    public void setScrawlMaxSize(int scrawlMaxSize) {
        this.scrawlMaxSize = scrawlMaxSize;
    }

    /**
     * 获取 图片访问路径前缀
     *
     * @return the scrawlUrlPrefix 图片访问路径前缀
     */
    public String getScrawlUrlPrefix() {
        return this.scrawlUrlPrefix;
    }

    /**
     * 设置 图片访问路径前缀
     *
     * @param scrawlUrlPrefix the 图片访问路径前缀 to set
     */
    public void setScrawlUrlPrefix(String scrawlUrlPrefix) {
        this.scrawlUrlPrefix = scrawlUrlPrefix;
    }

    /**
     * 获取 执行上传截图的action名称
     *
     * @return the scrawlInsertAlign 执行上传截图的action名称
     */
    public String getScrawlInsertAlign() {
        return this.scrawlInsertAlign;
    }

    /**
     * 设置 执行上传截图的action名称
     *
     * @param scrawlInsertAlign the 执行上传截图的action名称 to set
     */
    public void setScrawlInsertAlign(String scrawlInsertAlign) {
        this.scrawlInsertAlign = scrawlInsertAlign;
    }

    /**
     * 获取 上传保存路径可以自定义保存路径和文件名格式
     *
     * @return the snapscreenActionName 上传保存路径可以自定义保存路径和文件名格式
     */
    public String getSnapscreenActionName() {
        return this.snapscreenActionName;
    }

    /**
     * 设置 上传保存路径可以自定义保存路径和文件名格式
     *
     * @param snapscreenActionName the 上传保存路径可以自定义保存路径和文件名格式 to set
     */
    public void setSnapscreenActionName(String snapscreenActionName) {
        this.snapscreenActionName = snapscreenActionName;
    }

    /**
     * 获取 图片访问路径前缀
     *
     * @return the snapscreenPathFormat 图片访问路径前缀
     */
    public String getSnapscreenPathFormat() {
        return this.snapscreenPathFormat;
    }

    /**
     * 设置 图片访问路径前缀
     *
     * @param snapscreenPathFormat the 图片访问路径前缀 to set
     */
    public void setSnapscreenPathFormat(String snapscreenPathFormat) {
        this.snapscreenPathFormat = snapscreenPathFormat;
    }

    /**
     * 获取 插入的图片浮动方式
     *
     * @return the snapscreenUrlPrefix 插入的图片浮动方式
     */
    public String getSnapscreenUrlPrefix() {
        return this.snapscreenUrlPrefix;
    }

    /**
     * 设置 插入的图片浮动方式
     *
     * @param snapscreenUrlPrefix the 插入的图片浮动方式 to set
     */
    public void setSnapscreenUrlPrefix(String snapscreenUrlPrefix) {
        this.snapscreenUrlPrefix = snapscreenUrlPrefix;
    }

    /**
     * 获取
     *
     * @return the snapscreenInsertAlign
     */
    public String getSnapscreenInsertAlign() {
        return this.snapscreenInsertAlign;
    }

    /**
     * 设置
     *
     * @param snapscreenInsertAlign the  to set
     */
    public void setSnapscreenInsertAlign(String snapscreenInsertAlign) {
        this.snapscreenInsertAlign = snapscreenInsertAlign;
    }

    /**
     * 获取 抓取远程图片配置
     *
     * @return the catcherLocalDomain 抓取远程图片配置
     */
    public List<String> getCatcherLocalDomain() {
        return this.catcherLocalDomain;
    }

    /**
     * 设置 抓取远程图片配置
     *
     * @param catcherLocalDomain the 抓取远程图片配置 to set
     */
    public void setCatcherLocalDomain(List<String> catcherLocalDomain) {
        this.catcherLocalDomain = catcherLocalDomain;
    }

    /**
     * 获取 执行抓取远程图片的action名称
     *
     * @return the catcherActionName 执行抓取远程图片的action名称
     */
    public String getCatcherActionName() {
        return this.catcherActionName;
    }

    /**
     * 设置 执行抓取远程图片的action名称
     *
     * @param catcherActionName the 执行抓取远程图片的action名称 to set
     */
    public void setCatcherActionName(String catcherActionName) {
        this.catcherActionName = catcherActionName;
    }

    /**
     * 获取 提交的图片列表表单名称
     *
     * @return the catcherFieldName 提交的图片列表表单名称
     */
    public String getCatcherFieldName() {
        return this.catcherFieldName;
    }

    /**
     * 设置 提交的图片列表表单名称
     *
     * @param catcherFieldName the 提交的图片列表表单名称 to set
     */
    public void setCatcherFieldName(String catcherFieldName) {
        this.catcherFieldName = catcherFieldName;
    }

    /**
     * 获取 上传保存路径可以自定义保存路径和文件名格式
     *
     * @return the catcherPathFormat 上传保存路径可以自定义保存路径和文件名格式
     */
    public String getCatcherPathFormat() {
        return this.catcherPathFormat;
    }

    /**
     * 设置 上传保存路径可以自定义保存路径和文件名格式
     *
     * @param catcherPathFormat the 上传保存路径可以自定义保存路径和文件名格式 to set
     */
    public void setCatcherPathFormat(String catcherPathFormat) {
        this.catcherPathFormat = catcherPathFormat;
    }

    /**
     * 获取 图片访问路径前缀
     *
     * @return the catcherUrlPrefix 图片访问路径前缀
     */
    public String getCatcherUrlPrefix() {
        return this.catcherUrlPrefix;
    }

    /**
     * 设置 图片访问路径前缀
     *
     * @param catcherUrlPrefix the 图片访问路径前缀 to set
     */
    public void setCatcherUrlPrefix(String catcherUrlPrefix) {
        this.catcherUrlPrefix = catcherUrlPrefix;
    }

    /**
     * 获取 上传大小限制，单位B
     *
     * @return the catcherMaxSize 上传大小限制，单位B
     */
    public int getCatcherMaxSize() {
        return this.catcherMaxSize;
    }

    /**
     * 设置 上传大小限制，单位B
     *
     * @param catcherMaxSize the 上传大小限制，单位B to set
     */
    public void setCatcherMaxSize(int catcherMaxSize) {
        this.catcherMaxSize = catcherMaxSize;
    }

    /**
     * 获取 抓取图片格式显示
     *
     * @return the catcherAllowFiles 抓取图片格式显示
     */
    public List<String> getCatcherAllowFiles() {
        return this.catcherAllowFiles;
    }

    /**
     * 设置 抓取图片格式显示
     *
     * @param catcherAllowFiles the 抓取图片格式显示 to set
     */
    public void setCatcherAllowFiles(List<String> catcherAllowFiles) {
        this.catcherAllowFiles = catcherAllowFiles;
    }

    /**
     * 获取 执行上传视频的action名称
     *
     * @return the videoActionName 执行上传视频的action名称
     */
    public String getVideoActionName() {
        return this.videoActionName;
    }

    /**
     * 设置 执行上传视频的action名称
     *
     * @param videoActionName the 执行上传视频的action名称 to set
     */
    public void setVideoActionName(String videoActionName) {
        this.videoActionName = videoActionName;
    }

    /**
     * 获取 提交的视频表单名称
     *
     * @return the videoFieldName 提交的视频表单名称
     */
    public String getVideoFieldName() {
        return this.videoFieldName;
    }

    /**
     * 设置 提交的视频表单名称
     *
     * @param videoFieldName the 提交的视频表单名称 to set
     */
    public void setVideoFieldName(String videoFieldName) {
        this.videoFieldName = videoFieldName;
    }

    /**
     * 获取
     *
     * @return the videoPathFormat
     */
    public String getVideoPathFormat() {
        return this.videoPathFormat;
    }

    /**
     * 设置
     *
     * @param videoPathFormat the  to set
     */
    public void setVideoPathFormat(String videoPathFormat) {
        this.videoPathFormat = videoPathFormat;
    }

    /**
     * 获取 视频访问路径前缀
     *
     * @return the videoUrlPrefix 视频访问路径前缀
     */
    public String getVideoUrlPrefix() {
        return this.videoUrlPrefix;
    }

    /**
     * 设置 视频访问路径前缀
     *
     * @param videoUrlPrefix the 视频访问路径前缀 to set
     */
    public void setVideoUrlPrefix(String videoUrlPrefix) {
        this.videoUrlPrefix = videoUrlPrefix;
    }

    /**
     * 获取 上传大小限制，单位B，默认100MB
     *
     * @return the videoMaxSize 上传大小限制，单位B，默认100MB
     */
    public int getVideoMaxSize() {
        return this.videoMaxSize;
    }

    /**
     * 设置 上传大小限制，单位B，默认100MB
     *
     * @param videoMaxSize the 上传大小限制，单位B，默认100MB to set
     */
    public void setVideoMaxSize(int videoMaxSize) {
        this.videoMaxSize = videoMaxSize;
    }

    /**
     * 获取 上传视频格式显示
     *
     * @return the videoAllowFiles 上传视频格式显示
     */
    public List<String> getVideoAllowFiles() {
        return this.videoAllowFiles;
    }

    /**
     * 设置 上传视频格式显示
     *
     * @param videoAllowFiles the 上传视频格式显示 to set
     */
    public void setVideoAllowFiles(List<String> videoAllowFiles) {
        this.videoAllowFiles = videoAllowFiles;
    }

    /**
     * 获取 controller里执行上传视频的action名称
     *
     * @return the fileActionName controller里执行上传视频的action名称
     */
    public String getFileActionName() {
        return this.fileActionName;
    }

    /**
     * 设置 controller里执行上传视频的action名称
     *
     * @param fileActionName the controller里执行上传视频的action名称 to set
     */
    public void setFileActionName(String fileActionName) {
        this.fileActionName = fileActionName;
    }

    /**
     * 获取 提交的文件表单名称
     *
     * @return the fileFieldName 提交的文件表单名称
     */
    public String getFileFieldName() {
        return this.fileFieldName;
    }

    /**
     * 设置 提交的文件表单名称
     *
     * @param fileFieldName the 提交的文件表单名称 to set
     */
    public void setFileFieldName(String fileFieldName) {
        this.fileFieldName = fileFieldName;
    }

    /**
     * 获取 上传保存路径可以自定义保存路径和文件名格式
     *
     * @return the filePathFormat 上传保存路径可以自定义保存路径和文件名格式
     */
    public String getFilePathFormat() {
        return this.filePathFormat;
    }

    /**
     * 设置 上传保存路径可以自定义保存路径和文件名格式
     *
     * @param filePathFormat the 上传保存路径可以自定义保存路径和文件名格式 to set
     */
    public void setFilePathFormat(String filePathFormat) {
        this.filePathFormat = filePathFormat;
    }

    /**
     * 获取 文件访问路径前缀
     *
     * @return the fileUrlPrefix 文件访问路径前缀
     */
    public String getFileUrlPrefix() {
        return this.fileUrlPrefix;
    }

    /**
     * 设置 文件访问路径前缀
     *
     * @param fileUrlPrefix the 文件访问路径前缀 to set
     */
    public void setFileUrlPrefix(String fileUrlPrefix) {
        this.fileUrlPrefix = fileUrlPrefix;
    }

    /**
     * 获取 上传大小限制，单位B，默认50MB
     *
     * @return the fileMaxSize 上传大小限制，单位B，默认50MB
     */
    public int getFileMaxSize() {
        return this.fileMaxSize;
    }

    /**
     * 设置 上传大小限制，单位B，默认50MB
     *
     * @param fileMaxSize the 上传大小限制，单位B，默认50MB to set
     */
    public void setFileMaxSize(int fileMaxSize) {
        this.fileMaxSize = fileMaxSize;
    }

    /**
     * 获取 上传文件格式显示
     *
     * @return the fileAllowFiles 上传文件格式显示
     */
    public List<String> getFileAllowFiles() {
        return this.fileAllowFiles;
    }

    /**
     * 设置 上传文件格式显示
     *
     * @param fileAllowFiles the 上传文件格式显示 to set
     */
    public void setFileAllowFiles(List<String> fileAllowFiles) {
        this.fileAllowFiles = fileAllowFiles;
    }

    /**
     * 获取 执行图片管理的action名称
     *
     * @return the imageManagerActionName 执行图片管理的action名称
     */
    public String getImageManagerActionName() {
        return this.imageManagerActionName;
    }

    /**
     * 设置 执行图片管理的action名称
     *
     * @param imageManagerActionName the 执行图片管理的action名称 to set
     */
    public void setImageManagerActionName(String imageManagerActionName) {
        this.imageManagerActionName = imageManagerActionName;
    }

    /**
     * 获取 指定要列出图片的目录
     *
     * @return the imageManagerListPath 指定要列出图片的目录
     */
    public String getImageManagerListPath() {
        return this.imageManagerListPath;
    }

    /**
     * 设置 指定要列出图片的目录
     *
     * @param imageManagerListPath the 指定要列出图片的目录 to set
     */
    public void setImageManagerListPath(String imageManagerListPath) {
        this.imageManagerListPath = imageManagerListPath;
    }

    /**
     * 获取 每次列出文件数量
     *
     * @return the imageManagerListSize 每次列出文件数量
     */
    public int getImageManagerListSize() {
        return this.imageManagerListSize;
    }

    /**
     * 设置 每次列出文件数量
     *
     * @param imageManagerListSize the 每次列出文件数量 to set
     */
    public void setImageManagerListSize(int imageManagerListSize) {
        this.imageManagerListSize = imageManagerListSize;
    }

    /**
     * 获取 图片访问路径前缀
     *
     * @return the imageManagerUrlPrefix 图片访问路径前缀
     */
    public String getImageManagerUrlPrefix() {
        return this.imageManagerUrlPrefix;
    }

    /**
     * 设置 图片访问路径前缀
     *
     * @param imageManagerUrlPrefix the 图片访问路径前缀 to set
     */
    public void setImageManagerUrlPrefix(String imageManagerUrlPrefix) {
        this.imageManagerUrlPrefix = imageManagerUrlPrefix;
    }

    /**
     * 获取 插入的图片浮动方式
     *
     * @return the imageManagerInsertAlign 插入的图片浮动方式
     */
    public String getImageManagerInsertAlign() {
        return this.imageManagerInsertAlign;
    }

    /**
     * 设置 插入的图片浮动方式
     *
     * @param imageManagerInsertAlign the 插入的图片浮动方式 to set
     */
    public void setImageManagerInsertAlign(String imageManagerInsertAlign) {
        this.imageManagerInsertAlign = imageManagerInsertAlign;
    }

    /**
     * 获取 列出的文件类型
     *
     * @return the imageManagerAllowFiles 列出的文件类型
     */
    public List<String> getImageManagerAllowFiles() {
        return this.imageManagerAllowFiles;
    }

    /**
     * 设置 列出的文件类型
     *
     * @param imageManagerAllowFiles the 列出的文件类型 to set
     */
    public void setImageManagerAllowFiles(List<String> imageManagerAllowFiles) {
        this.imageManagerAllowFiles = imageManagerAllowFiles;
    }

    /**
     * 获取 执行文件管理的action名称
     *
     * @return the fileManagerActionName 执行文件管理的action名称
     */
    public String getFileManagerActionName() {
        return this.fileManagerActionName;
    }

    /**
     * 设置 执行文件管理的action名称
     *
     * @param fileManagerActionName the 执行文件管理的action名称 to set
     */
    public void setFileManagerActionName(String fileManagerActionName) {
        this.fileManagerActionName = fileManagerActionName;
    }

    /**
     * 获取 指定要列出文件的目录
     *
     * @return the fileManagerListPath 指定要列出文件的目录
     */
    public String getFileManagerListPath() {
        return this.fileManagerListPath;
    }

    /**
     * 设置 指定要列出文件的目录
     *
     * @param fileManagerListPath the 指定要列出文件的目录 to set
     */
    public void setFileManagerListPath(String fileManagerListPath) {
        this.fileManagerListPath = fileManagerListPath;
    }

    /**
     * 获取 文件访问路径前缀
     *
     * @return the fileManagerUrlPrefix 文件访问路径前缀
     */
    public String getFileManagerUrlPrefix() {
        return this.fileManagerUrlPrefix;
    }

    /**
     * 设置 文件访问路径前缀
     *
     * @param fileManagerUrlPrefix the 文件访问路径前缀 to set
     */
    public void setFileManagerUrlPrefix(String fileManagerUrlPrefix) {
        this.fileManagerUrlPrefix = fileManagerUrlPrefix;
    }

    /**
     * 获取 每次列出文件数量
     *
     * @return the fileManagerListSize 每次列出文件数量
     */
    public int getFileManagerListSize() {
        return this.fileManagerListSize;
    }

    /**
     * 设置 每次列出文件数量
     *
     * @param fileManagerListSize the 每次列出文件数量 to set
     */
    public void setFileManagerListSize(int fileManagerListSize) {
        this.fileManagerListSize = fileManagerListSize;
    }

    /**
     * 获取 列出的文件类型
     *
     * @return the fileManagerAllowFiles 列出的文件类型
     */
    public List<String> getFileManagerAllowFiles() {
        return this.fileManagerAllowFiles;
    }

    /**
     * 设置 列出的文件类型
     *
     * @param fileManagerAllowFiles the 列出的文件类型 to set
     */
    public void setFileManagerAllowFiles(List<String> fileManagerAllowFiles) {
        this.fileManagerAllowFiles = fileManagerAllowFiles;
    }
}
