package com.yd.rmi.ali.mailinterf.service;
import java.io.UnsupportedEncodingException;
import java.util.List;

public interface AliMailInterfService {
    /**
     * 单封邮件发送
     * @param toAddress
     * @param subject
     * @param messageHtml
     * @param messageText
     */
    public void singleSend(String toAddress,
                           String subject,
                           String messageHtml,
                           String messageText);
    /**
     * 批量邮件发送
     * @param templateName	邮件模板："成功投保模板"
     * @param receiversName	收件人列表："测试控制台发邮件"
     */
    public void batchSend(String templateName,String receiversName);

    /**
     * SMTP邮件发送
     * @param toAddress	收件人地址
     * @param ccAddresses 抄送人地址数组
     * @param subject	邮件标题
     * @param messageText	邮件正文文本
     * @param attachmentFiles	附件路径
     * @param imageFile	图片路径
     */
    public void smtpSend(String toAddress,
                         String[] ccAddresses,
                         String subject,
                         String messageText,
                         List<String> attachmentFiles,
                         String imageFile) throws UnsupportedEncodingException, Exception;
}
