package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_customer
 * @author 
 */
@Data
public class AclCustomer implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * 1= Staff 2=Customer 3=Partner 6=VIP 9=Car Insurance Chanel
     */
    private Integer role;

    /**
     * customer# for referral use -######## = login ID 
     */
    private String accountId;

    private String login;

    private String mobileNo;

    /**
     * for mobile
     */
    private String authenCode;

    /**
     * for staff or partner
     */
    private String password;

    private String email;

    /**
     * FK ag_md_province.id 省
     */
    private Long provinceId;

    /**
     * FK ag_md_city.id 城市
     */
    private Long cityId;

    /**
     * FK ag_md_district.id 县(区)
     */
    private Long districtId;

    /**
     * mailing address
     */
    private String address;

    /**
     * FK ag_md_industry_occupation.id
     */
    private Long occupationId;

    /**
     * 1=普通会员 2=黄金会员 3=白金会员 4=黑金会员 5=钻石会员  
     */
    private Integer cusLevel;

    /**
     * Chinese Name
     */
    private String name;

    /**
     * 自行编辑昵称
     */
    private String nicknameModify;

    /**
     * Englsih First name
     */
    private String enFirstname;

    /**
     * English Last name
     */
    private String enLastname;

    /**
     * ag_md_id_type.id
     */
    private Long idTypeId;

    private String idNo;

    /**
     * 1=Male, 2=Female
     */
    private Integer gender;

    /**
     * 0000-00-00
     */
    private Date birthDate;

    private Date lastLoginTime;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 0=逐单提现, 1=对冲记录提现
     */
    private Integer withdrawType;

    private BigDecimal referralRate;

    private BigDecimal referralTotalAmount;

    /**
     * FK ag_acl_channel_referral_rate.id 角色渠道推荐佣金比率对应
     */
    private Long channelReferralRateId;

    /**
     * URL path of of Customer picture
     */
    private String imagePath;

    /**
     * 微信客户标识,对当前开发账户唯一
     */
    private String wechatOpenid;

    /**
     * 银盾经纪公众号的微信客户标识,对当前开发账户唯一
     */
    private String ydWechatOpenid;

    /**
     * 微信调接昵称
     */
    private String nickname;

    /**
     * FK ag_system_dept.id
     */
    private Long deptId;

    /**
     * FK ag_system_role.id
     */
    private Long roleId;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    private Long updatedBy;

    /**
     * 推荐达人等级 1=一袋达人 2=二袋达人 3=三袋达人 4=四袋达人 5=五袋达人
     */
    private Integer referralLevel;

    /**
     * 执业者编号(登记代理人资格)
     */
    private String practitionerRegNo;

    /**
     * 所属公司(登记代理人资格)
     */
    private String practitionerRegCompany;

    /**
     * 执业证有效日期(登记代理人资格)
     */
    private Date practitionerRegExpirydate;

    /**
     * 执业证是否有效 0=无效, 1=有效
     */
    private Integer practitionerRegStatus;

    /**
     * 执业者教育程度 1博士 2硕士 3本科 4大专 5高中及同等学历 6初中及同等学历 7初中以下学历
     */
    private Integer practitionerRegEducationLevel;

    /**
     * 执业登记姓名
     */
    private String practitionerRegName;

    /**
     * 执业登记者的证件类型 FK ag_md_id_type, 1=身份证 2=护照 4=台胞证 5=香港身份证
     */
    private Integer practitionerIdTypeId;

    /**
     * 执业登记者的证件号
     */
    private String practitionerIdNo;

    /**
     * 执业登记者的生日
     */
    private Date practitionerBirthdate;

    /**
     * 执业登记者的性别 1=Male, 2=Female
     */
    private Integer practitionerGender;

    /**
     * 执业登记者大头照存放的URL
     */
    private String practitionerPortaitUrl;

    /**
     * 营销投放渠道来源 hmsr
     */
    private String sourceChannel;

    /**
     * 活动
     */
    private String mktCampaign;

    /**
     * 活动任务
     */
    private String mktTask;

    /**
     * 营销投放产品名 hmpl
     */
    private String sourcePlanName;

    /**
     * 营销投放推送日期 hmkw
     */
    private String sourcePublishdate;

    /**
     * 营销投放推送文章或其他 hmci
     */
    private String sourceArticle;

    /**
     * 微信号
     */
    private String wechatNo;

    /**
     * 其他联系方式
     */
    private String otherContacts;

    /**
     * 年龄
     */
    private Long age;


    private static final long serialVersionUID = 1L;
}