package com.yd.rmi.n22.staff.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yd.rmi.cache.SystemConfigService;
import com.yd.rmi.n22.common.utils.N22Utils;
import com.yd.rmi.n22.policy.service.impl.N22PolicyServiceImpl;
import com.yd.rmi.n22.staff.pojo.GetStaffNewRequestBody;
import com.yd.rmi.n22.staff.pojo.GetStaffNewResponseVO;
import com.yd.rmi.n22.staff.pojo.Staff;
import com.yd.rmi.n22.staff.service.N22StaffService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.UUID;

@Service
public class N22StaffServiceImpl implements N22StaffService {

    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public GetStaffNewResponseVO getStaffNew(GetStaffNewRequestBody getStaffNewRequestBody) {

        JSONObject obj = new JSONObject(); //传参

        JSONObject requestHead = new JSONObject();
        requestHead.put("seqNo", UUID.randomUUID().toString());

        obj.put("requestHead", requestHead);
        obj.put("requestBody", getStaffNewRequestBody);

        String url = systemConfigService.getSingleConfigValue("N22_URL_Get_Staff_New");
        String result = N22Utils.postTransaction(url, obj.toString());

        GetStaffNewResponseVO response = JSONObject.parseObject(result, GetStaffNewResponseVO.class);

        return response;
    }

    @Override
    public Staff queryN22StaffByMobileNo(String mobileNo) {

        GetStaffNewRequestBody getStaffNewRequestBody = new GetStaffNewRequestBody();
        getStaffNewRequestBody.setMobile(mobileNo);

        GetStaffNewResponseVO resp = this.getStaffNew(getStaffNewRequestBody);

        Staff staff = null;
        if(resp != null){
            if ("查询成功".equals(resp.getResponseHead().getMessage())){
                List<Staff> staffList = resp.getResponseBody().getStaff();
                if (staffList.size() > 0) {
                    staff = staffList.get(0);
                }
            }
        }
        return staff;
    }
}
