package com.yd.api.practitioner.service.impl;

import com.yd.api.practitioner.service.PractitionerArticleService;
import com.yd.api.practitioner.vo.ArticleTrackSaveResponseVO;
import com.yd.api.practitioner.vo.article.ArticleShareCodeSaveRequestVO;
import com.yd.api.practitioner.vo.article.ArticleShareCodeSaveResponseVO;
import com.yd.api.practitioner.vo.article.ArticleTrackQueryResponseVO;
import com.yd.api.practitioner.vo.article.ArticleTrackSaveRequestVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclCustomerObjectShare;
import com.yd.dal.entity.customer.AclCustomerObjectShareTrack;
import com.yd.dal.entity.practitioner.article.ArticleTrackQueryInfo;
import com.yd.dal.service.customer.AclCustomerObjectShareDALService;
import com.yd.dal.service.customer.AclCustomerObjectShareTrackDALService;
import com.yd.dal.service.practitioner.PractitionerArticleDALService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("practitionerArticleService")
public class PractitionerArticleServiceImpl implements PractitionerArticleService {
    @Autowired
    private AclCustomerObjectShareDALService aclCustomerObjectShareDALService;
    @Autowired
    private AclCustomerObjectShareTrackDALService aclCustomerObjectShareTrackDALService;
    @Autowired
    private PractitionerArticleDALService practitionerArticleDALService;
    @Override
    public ArticleShareCodeSaveResponseVO articleShareCodeSave(ArticleShareCodeSaveRequestVO requestVO) {
        ArticleShareCodeSaveResponseVO responseVO = new ArticleShareCodeSaveResponseVO();
        AclCustomerObjectShare objectShare = new AclCustomerObjectShare();
        BeanUtils.copyProperties(requestVO,objectShare);
        objectShare.setItemType(1);
        objectShare.setCreatedAt(new Date());
        objectShare.setCreatedBy(-1L);
        Long id = aclCustomerObjectShareDALService.save(objectShare);
        responseVO.setId(id);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public ArticleTrackSaveResponseVO articleTrackSave(ArticleTrackSaveRequestVO requestVO) {
        ArticleTrackSaveResponseVO responseVO = new ArticleTrackSaveResponseVO();
        AclCustomerObjectShareTrack shareTrack = new AclCustomerObjectShareTrack();
        BeanUtils.copyProperties(requestVO,shareTrack);
        shareTrack.setCreatedAt(new Date());
        shareTrack.setCreatedBy(-1L);
        Long id = requestVO.getId();
        if (CommonUtil.isNullOrZero(id)){
            String shareCode = shareTrack.getShareCode();
            Long shareCodeId = aclCustomerObjectShareDALService.findIdByShareCode(shareCode);
            shareTrack.setShareId(shareCodeId);
            shareTrack.setTrackInTime(new Date());
            id = aclCustomerObjectShareTrackDALService.save(shareTrack);
        }else {
            shareTrack.setTrackOutTime(new Date());
            aclCustomerObjectShareTrackDALService.update(shareTrack);
        }
        responseVO.setId(id);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public ArticleTrackQueryResponseVO articleTrackQuery(Long practitionerId,Long sharingId) {
        ArticleTrackQueryResponseVO responseVO = new ArticleTrackQueryResponseVO();
        //通过经纪人id和文章id查询 客户跟踪信息
        List<ArticleTrackQueryInfo> articleTrackQueryInfos = practitionerArticleDALService.articleTrackQuery(practitionerId,sharingId);
        responseVO.setArticleTrackQueryInfos(articleTrackQueryInfos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }
}
