package com.yd.api.customer.service.impl;

import com.yd.api.customer.service.CustomerTrackVideoService;
import com.yd.api.customer.vo.trackvideo.AddCustomerTrackVideoRequestVO;
import com.yd.api.customer.vo.trackvideo.QueryDetailsByIdResponseVO;
import com.yd.api.customer.vo.trackvideo.QueryTrackListRequestVO;
import com.yd.api.customer.vo.trackvideo.QueryTrackListResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.api.result.CommonResultResponseVO;
import com.yd.dal.entity.customer.trackvideo.AgAclCustomerBehaviorTrackVideo;
import com.yd.dal.mapper.customer.trackvideo.AgAclCustomerBehaviorTrackVideoMapper;
import com.yd.rmi.ali.oss.service.OssService;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Service("CustomerTrackVideoService")
public class CustomerTrackVideoServiceImpl implements CustomerTrackVideoService {
    @Autowired
    private OssService ossService;
    @Autowired
    private AgAclCustomerBehaviorTrackVideoMapper customerBehaviorTrackVideoMapper;

    @Override
    public CommonResultResponseVO add(AddCustomerTrackVideoRequestVO requestVO, MultipartFile dataFile) {
        CommonResultResponseVO resp = new CommonResultResponseVO();

        AgAclCustomerBehaviorTrackVideo trackVideo = new AgAclCustomerBehaviorTrackVideo();
        BeanUtils.copyProperties(requestVO, trackVideo);

        try {
            // 获取文件
            String token = requestVO.getToken();
            String shortToken = token.substring(token.length() - 10);

            String prefix = "customerBehaviorTrackVideo/" + shortToken + "/";

            SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmssSSS");
            String filename = sdf.format(new Date());
            String ossKey = prefix + filename;
            // 将txt上传到oss
            String fileOssPath = ossService.putFileToOss(null, ossKey, dataFile.getInputStream());

            // 保存入库
            trackVideo.setDataOssPath(fileOssPath);
            trackVideo.setIsActive(1);
            trackVideo.setCreatedAt(new Date());
            trackVideo.setCreatedBy(-1L);
            trackVideo.setUpdatedAt(new Date());
            trackVideo.setUpdatedBy(-1L);

            customerBehaviorTrackVideoMapper.insert(trackVideo);

            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));

        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("800001")));
        }
        return resp;
    }

    @Override
    public QueryTrackListResponseVO queryTrackList(QueryTrackListRequestVO requestVO) {
        QueryTrackListResponseVO resp = new QueryTrackListResponseVO();
        try {
            List<AgAclCustomerBehaviorTrackVideo> list = customerBehaviorTrackVideoMapper.selectByRecord(requestVO);

            resp.setList(list);
            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));

        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("800001")));
        }
        return resp;
    }

    @Override
    public QueryDetailsByIdResponseVO queryDetailsById(Long id) {
        QueryDetailsByIdResponseVO resp = new QueryDetailsByIdResponseVO();
        try {
            AgAclCustomerBehaviorTrackVideo trackVideo = customerBehaviorTrackVideoMapper.selectByPrimaryKey(id);

            resp.setTrackVideo(trackVideo);
            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));

        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("800001")));
        }
        return resp;
    }

}
