package com.yd.util.config;
/**
 * Register security zuihuibi filter
 */
import javax.servlet.Filter;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.CharacterEncodingFilter;

import com.yd.util.auth.filter.HttpZuihuibiAuthorizeFilter;

@Configuration
public class HttpZuihuibiAuthorizeConfig {

	@Bean
    public Filter AuthFilter() {
        return new HttpZuihuibiAuthorizeFilter();
    }
	@Bean
    @Order(Ordered.HIGHEST_PRECEDENCE)
    CharacterEncodingFilter characterEncodingFilter() {
        CharacterEncodingFilter filter = new CharacterEncodingFilter();
        filter.setEncoding("UTF-8");
        filter.setForceEncoding(true);
        filter.setForceRequestEncoding(true);
        filter.setForceResponseEncoding(true);
        return filter;
    }	
}
