package com.yd.rmi.tencent.wechat.service;

import com.yd.rmi.tencent.wechat.vo.WxNATIVEPayQueryReqVO;
import com.yd.rmi.tencent.wechat.vo.WxNATIVEPayQueryRespVO;
import com.yd.rmi.tencent.wechat.vo.WxUserInfo;
import com.yd.rmi.tencent.wechatinterf.pojo.accesstoken.AccessTokenResponse;
import com.yd.rmi.tencent.wechatinterf.pojo.ticket.TicketRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.token.TokenRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.unifiedorder.UnifiedorderResponse;

import java.util.Map;

public interface WechatService {
	public String obtainToken(TokenRequest tokenRequest);
	public String obtainTicket(TicketRequest ticketRequest);
	public UnifiedorderResponse unifiedorder(String appId, String openId, String wCpayMethod, String timeExpire, String mchId, Double orderPrice, String planName, String orderNo, String notifyUrl);
	/**
	 * 生成签名
	 * @param paraMap
	 * @param urlEncode
	 * @param keyToLower
	 * @param oppid
	 * @param key
	 * @return
	 */
	public String getSignValue(Map<String, String> paraMap,boolean urlEncode,boolean keyToLower,String oppid,String key);
	/**
	 * 微信扫码支付结果查询接口
	 * @param wxNATIVEPayQueryReqVO
	 */
	public WxNATIVEPayQueryRespVO nativePayQuery(WxNATIVEPayQueryReqVO wxNATIVEPayQueryReqVO);
	/**
	 * http连接
	 * @param httpURL 地址
	 * @param requestXML XML内容
	 * @return
	 */
	public String transaction(String authorizeURL, Object object);
	/**
	 * 微信公众号支付组装html
	 * @param appId
	 * @param timeStamp
	 * @param nonceStr
	 * @param prepay_id
	 * @return
	 */
	public String weixinJSBridge(String appid, String timeStamp, String nonceStr, String prepayId, String notifyUrl,
			String key);
	/**
	 * JS-SDK使用权限签名算法
	 * @param jsapi_ticket
	 * @param url
	 * @return
	 */
	public Map<String, String> jsapiTicketSign(String jsapiTicket, String url); 
	/**
	 * 微信获取用户的openid
	 * @param appid
	 * @param secret
	 * @param code
	 * @return
	 */
	public AccessTokenResponse getOpenID(String appid, String secret, String code);
	/**
	 * 微信获取用户的详细信息
	 * @param openId 
	 * @param accessToken
	 * @return  WxUserInfo
	 */
	public WxUserInfo getWxUserInfo(String openId, String accessToken);
	
}
