package com.yd.dal.entity.meta;

import java.util.Date;
import lombok.Data;

/**
    * 前端显示标签表
 * @author xxy
 */
public class MdTagView {
    /**
    * serial id
    */
    private Long id;

    /**
    * 标签显示类别(1=12宫格; 2=左侧热榜列表; 3=右上角筛选)
    */
    private String tagViewType;

    /**
    * 标签ID
    */
    private Long tagId;

    /**
    * 标签名称
    */
    private String tagName;

    /**
    * 标签级别(1=一级标签;2=二级标签;3=三级标签,以此类推)
    */
    private String tagLevel;

    /**
    * 上级前端显示标签ID
    */
    private Long upperTagViewId;

    /**
    * UI上显示图片
    */
    private String displayImage;

    /**
    * UI上layout优先级
    */
    private Integer displayOrder;

    /**
    * 1=active 2=inactive
    */
    private Integer isActive;

    /**
    * 备注
    */
    private String remark;

    /**
    * 创建时间
    */
    private Date createdAt;

    /**
    * FK ag_acl_user.id
    */
    private Long createdBy;

    /**
    * 修改时间
    */
    private Date updatedAt;

    /**
    * FK ag_acl_user.id
    */
    private Long updatedBy;
    
    private String upperTagViewName;

    /**
     * Gets the value of id. *
     *
     * @return the value of id
     */
    public Long getId() {
        return id;
    }

    /**
     * Sets the id. *
     * <p>You can use getId() to get the value of id</p>
     * * @param id id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Gets the value of tagViewType. *
     *
     * @return the value of tagViewType
     */
    public String getTagViewType() {
        return tagViewType;
    }

    /**
     * Sets the tagViewType. *
     * <p>You can use getTagViewType() to get the value of tagViewType</p>
     * * @param tagViewType tagViewType
     */
    public void setTagViewType(String tagViewType) {
        this.tagViewType = tagViewType;
    }

    /**
     * Gets the value of tagId. *
     *
     * @return the value of tagId
     */
    public Long getTagId() {
        return tagId;
    }

    /**
     * Sets the tagId. *
     * <p>You can use getTagId() to get the value of tagId</p>
     * * @param tagId tagId
     */
    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    /**
     * Gets the value of tagName. *
     *
     * @return the value of tagName
     */
    public String getTagName() {
        return tagName;
    }

    /**
     * Sets the tagName. *
     * <p>You can use getTagName() to get the value of tagName</p>
     * * @param tagName tagName
     */
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    /**
     * Gets the value of tagLevel. *
     *
     * @return the value of tagLevel
     */
    public String getTagLevel() {
        return tagLevel;
    }

    /**
     * Sets the tagLevel. *
     * <p>You can use getTagLevel() to get the value of tagLevel</p>
     * * @param tagLevel tagLevel
     */
    public void setTagLevel(String tagLevel) {
        this.tagLevel = tagLevel;
    }

    /**
     * Gets the value of upperTagViewId. *
     *
     * @return the value of upperTagViewId
     */
    public Long getUpperTagViewId() {
        return upperTagViewId;
    }

    /**
     * Sets the upperTagViewId. *
     * <p>You can use getUpperTagViewId() to get the value of upperTagViewId</p>
     * * @param upperTagViewId upperTagViewId
     */
    public void setUpperTagViewId(Long upperTagViewId) {
        this.upperTagViewId = upperTagViewId;
    }

    /**
     * Gets the value of displayImage. *
     *
     * @return the value of displayImage
     */
    public String getDisplayImage() {
        return displayImage;
    }

    /**
     * Sets the displayImage. *
     * <p>You can use getDisplayImage() to get the value of displayImage</p>
     * * @param displayImage displayImage
     */
    public void setDisplayImage(String displayImage) {
        this.displayImage = displayImage;
    }

    /**
     * Gets the value of displayOrder. *
     *
     * @return the value of displayOrder
     */
    public Integer getDisplayOrder() {
        return displayOrder;
    }

    /**
     * Sets the displayOrder. *
     * <p>You can use getDisplayOrder() to get the value of displayOrder</p>
     * * @param displayOrder displayOrder
     */
    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    /**
     * Gets the value of isActive. *
     *
     * @return the value of isActive
     */
    public Integer getIsActive() {
        return isActive;
    }

    /**
     * Sets the isActive. *
     * <p>You can use getIsActive() to get the value of isActive</p>
     * * @param isActive isActive
     */
    public void setIsActive(Integer isActive) {
        this.isActive = isActive;
    }

    /**
     * Gets the value of remark. *
     *
     * @return the value of remark
     */
    public String getRemark() {
        return remark;
    }

    /**
     * Sets the remark. *
     * <p>You can use getRemark() to get the value of remark</p>
     * * @param remark remark
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * Gets the value of createdAt. *
     *
     * @return the value of createdAt
     */
    public Date getCreatedAt() {
        return createdAt;
    }

    /**
     * Sets the createdAt. *
     * <p>You can use getCreatedAt() to get the value of createdAt</p>
     * * @param createdAt createdAt
     */
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * Gets the value of createdBy. *
     *
     * @return the value of createdBy
     */
    public Long getCreatedBy() {
        return createdBy;
    }

    /**
     * Sets the createdBy. *
     * <p>You can use getCreatedBy() to get the value of createdBy</p>
     * * @param createdBy createdBy
     */
    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    /**
     * Gets the value of updatedAt. *
     *
     * @return the value of updatedAt
     */
    public Date getUpdatedAt() {
        return updatedAt;
    }

    /**
     * Sets the updatedAt. *
     * <p>You can use getUpdatedAt() to get the value of updatedAt</p>
     * * @param updatedAt updatedAt
     */
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    /**
     * Gets the value of updatedBy. *
     *
     * @return the value of updatedBy
     */
    public Long getUpdatedBy() {
        return updatedBy;
    }

    /**
     * Sets the updatedBy. *
     * <p>You can use getUpdatedBy() to get the value of updatedBy</p>
     * * @param updatedBy updatedBy
     */
    public void setUpdatedBy(Long updatedBy) {
        this.updatedBy = updatedBy;
    }

    /**
	 * @return the upperTagViewName
	 */
	public String getUpperTagViewName() {
		return upperTagViewName;
	}

	/**
	 * @param upperTagViewName the upperTagViewName to set
	 */
	public void setUpperTagViewName(String upperTagViewName) {
		this.upperTagViewName = upperTagViewName;
	}

	@Override
    public String toString() {
        return "MdTagView{" +
                "id=" + id +
                ", tagViewType='" + tagViewType + '\'' +
                ", tagId=" + tagId +
                ", tagName='" + tagName + '\'' +
                ", tagLevel='" + tagLevel + '\'' +
                ", upperTagViewId=" + upperTagViewId +
                ", displayImage='" + displayImage + '\'' +
                ", displayOrder=" + displayOrder +
                ", isActive=" + isActive +
                ", remark='" + remark + '\'' +
                ", createdAt=" + createdAt +
                ", createdBy=" + createdBy +
                ", updatedAt=" + updatedAt +
                ", updatedBy=" + updatedBy +
                '}';
    }
}