package com.yd.dal.entity.marketing;

import java.util.Date;
import lombok.Data;

/**
 * 经纪人商机活动量分摊细化设置
 */
@Data
public class MktLeadsGoalsActions {
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_practitioner.id 经纪人
     */
    private Long practitionerId;

    /**
     * 目标所属年度
     */
    private Integer currentYear;

    /**
     * 2：季度，3：月度
     */
    private Integer statisticTimeUnit;

    /**
     * FK ag_md_drop_options.id 商机销售行动drop_master id = 14
     */
    private Long leadsActionId;

    /**
     * FK ag_md_drop_options.drop_option_name 团队长发掘活动drop_master id = 14
     */
    private String leadsActionName;

    /**
     * 成交件数a
     * 建议书数量b = a * 3
     * 见面沟通次数c = b
     * 电话/微信沟通次数d = c * 3
     * 安排见面次数f = c * 3
     * 获取商机次数g = f
     */
    private Integer actionStandards;

    /**
     * 版本控制
     */
    private Date currentVersion;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    private Long updatedBy;
}