package com.yd.dal.service.agms.impl;

import com.yd.api.agms.vo.dashboard.StatisticsPractitionerInfo;
import com.yd.api.agms.vo.dashboard.StatisticsSalesInfo;
import com.yd.dal.entity.agms.dashboard.StatisticsOpportunityInfo;
import com.yd.dal.entity.agms.dashboard.StatisticsPEPInfo;
import com.yd.dal.mapper.agms.AgmsDashboardMapper;
import com.yd.dal.service.agms.AgmsDashboardDALService;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;

@Service("agmsDashboardDALService")
public class AgmsDashboardDALServiceImpl implements AgmsDashboardDALService {

    @Resource
    private AgmsDashboardMapper agmsDashboardMapper;

    @Override
    public List<StatisticsPEPInfo> statisticsPEP(String type,Long dropOptionId) {
        return agmsDashboardMapper.statisticsPEP(type,dropOptionId);
    }

    @Override
    public List<StatisticsOpportunityInfo> statisticsOpportunity(String type,String time, Long dropOptionId) {
        return agmsDashboardMapper.statisticsOpportunity(type , time, dropOptionId);
    }

    @Override
    public List<StatisticsSalesInfo> statisticsSalesYD(String type, String time) {
        List<StatisticsSalesInfo> statisticsSalesInfos = agmsDashboardMapper.statisticsSalesYD(type,time);
        getUnitPremium(statisticsSalesInfos);
        return statisticsSalesInfos;
    }

    /**
     * 获取均件保费
     * @param statisticsSalesInfos
     */
    private void getUnitPremium(List<StatisticsSalesInfo> statisticsSalesInfos) {
        if(statisticsSalesInfos != null && statisticsSalesInfos.size() > 0){
            String fyp;
            Integer pieces;
            for(StatisticsSalesInfo item : statisticsSalesInfos){
                fyp = item.getFyp();
                pieces = item.getPieces();
                if(pieces != null && pieces != 0){
                    item.setUnitPremium(BigDecimal.valueOf(Double.parseDouble(fyp) / pieces).setScale(2,BigDecimal.ROUND_HALF_UP).toString());
                }
            }
        }
    }

    @Override
    public List<StatisticsPractitionerInfo> statisticsPractitioner(String type) {
        List<StatisticsPractitionerInfo> statisticsPractitionerInfos = agmsDashboardMapper.statisticsPractitioner(type);
        //计算实动率
        if(statisticsPractitionerInfos != null && statisticsPractitionerInfos.size() > 0){
            Integer realAmount,amount;
            for(StatisticsPractitionerInfo item : statisticsPractitionerInfos){
                realAmount = item.getRealAmount();
                amount = item.getAmount();
                if(amount > 0){
                    item.setRealRate(BigDecimal.valueOf((realAmount.doubleValue() / amount.doubleValue()) * 100).setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue());
                }
            }
        }
        return statisticsPractitionerInfos;
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<StatisticsSalesInfo> statisticsSalesEG(String type, String time) {
        List<StatisticsSalesInfo> statisticsSalesInfos = agmsDashboardMapper.statisticsSalesEG(type,time);
        getUnitPremium(statisticsSalesInfos);
        return statisticsSalesInfos;
    }
}
