package com.yd.dal.service.customer;

import com.yd.dal.entity.customer.AclPractitionerSubordinateSystem;
import com.yd.dal.entity.customer.practitioner.PractitionerSubordinateInfo;
import com.yd.dal.entity.customer.practitioner.SubordinateSystemMemberInfoE;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("aclPractitionerSubordinateSystemDALService")
public interface AclPractitionerSubordinateSystemDALService {
    PractitionerSubordinateInfo findSubordinateInfo(Long subordinateId);


    AclPractitionerSubordinateSystem findByPractitionerId(Long practitionerId);

    List<AclPractitionerSubordinateSystem> findByOwnerPractitionerId(Long practitionerId);

    List<AclPractitionerSubordinateSystem> findByOwner(Long practitionerId);

    PractitionerSubordinateInfo findByOwnerE(String practitionerId);

    List<SubordinateSystemMemberInfoE> findStatisticsE(String subordinateIdForEGolden, Integer time);

    List<SubordinateSystemMemberInfoE> findStatisticsEBymobileList(List<String> mobileNoList, Integer time);

    AclPractitionerSubordinateSystem findById(Long subsystemId);

    List<AclPractitionerSubordinateSystem> findByDeptId(Long deptId);

    List<AclPractitionerSubordinateSystem> findByInsurerBranchId(Long insurerBranchId);

    List<AclPractitionerSubordinateSystem> findDeptIdAndInsureBranchIdNull(Long  insurerId);

    List<AclPractitionerSubordinateSystem> findDeptIdNotNull(Long insurerId);

    /**
     * 组织架构体系查询改造,如果条件是S3,则需要查询出其组织下的所有子集。
     * @return
     */
    public List<Long> getLongs(PractitionerSubordinateInfo practitionerSubordinateInfo);

    /**
     * 递归获取某个父节点下面的所有子节点
     * @param childOrg 要返回的结果
     * @param allList  数据库查询出来的所有集合
     * @param pid      父id
     */
    public void orgRecursion(List<AclPractitionerSubordinateSystem> childOrg, List<AclPractitionerSubordinateSystem> allList, Long pid);

}
