package com.yd.api.agms.service;

import com.yd.api.agms.vo.statistics.FinancialStatisticsRequestVO;
import com.yd.api.agms.vo.statistics.FinancialStatisticsResponseVO;
import com.yd.api.agms.vo.statistics.LeadsStatisticsRequestVO;
import com.yd.api.agms.vo.statistics.LeadsStatisticsResponseVO;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;

@Service("agmsStatementService")
public interface AgmsStatisticsService {
    /**
     * 线下寿险预估数据管理报表
     * @param requestVO 请求报文
     * @return 响应报文
     */
    FinancialStatisticsResponseVO financialPredictStatistics(FinancialStatisticsRequestVO requestVO, HttpServletResponse response);

    /**
     * 商机统计报表
     * @param requestVO 请求报文
     * @return 响应报文
     */
    LeadsStatisticsResponseVO leadsStatistics(LeadsStatisticsRequestVO requestVO,HttpServletResponse response);
}
