/*
 * Decompiled with CFR 0.152.
 */
package com.libs.pdf;

import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.PrivateKeySignature;
import com.libs.pdf.PDFTemplate;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PDFSign {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sign(String password, String keyStorePath, String signPdfSrc, String signImage, int signPage, float x, float y) {
        char[] passwords = password.toCharArray();
        File signPdfSrcFile = new File(signPdfSrc);
        PdfReader reader = null;
        ByteArrayOutputStream signPDFData = null;
        PdfStamper stp = null;
        FileInputStream fos = null;
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            fos = new FileInputStream(keyStorePath);
            ks.load(fos, passwords);
            String alias = ks.aliases().nextElement();
            PrivateKey key = (PrivateKey)ks.getKey(alias, passwords);
            Certificate[] chain = ks.getCertificateChain(alias);
            reader = new PdfReader(signPdfSrc);
            signPDFData = new ByteArrayOutputStream();
            File temp = new File(signPdfSrcFile.getParent(), System.currentTimeMillis() + ".pdf");
            stp = PdfStamper.createSignature((PdfReader)reader, (OutputStream)signPDFData, (char)'\u0000', (File)temp, (boolean)true);
            stp.setFullCompression();
            PdfSignatureAppearance sap = stp.getSignatureAppearance();
            sap.setReason("\u6570\u5b57\u7b7e\u540d\uff0c\u4e0d\u53ef\u6539\u53d8");
            int pageCount = reader.getNumberOfPages();
            Image image = Image.getInstance((String)signImage);
            sap.setImageScale(0.0f);
            sap.setSignatureGraphic(image);
            sap.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC);
            sap.setVisibleSignature(new Rectangle(x, y, x + 100.0f, y + image.getHeight()), signPage, UUID.randomUUID().toString().replaceAll("-", ""));
            stp.getWriter().setCompressionLevel(5);
            BouncyCastleDigest digest = new BouncyCastleDigest();
            PrivateKeySignature signature = new PrivateKeySignature(key, "SHA-1", null);
            MakeSignature.signDetached((PdfSignatureAppearance)sap, (ExternalDigest)digest, (ExternalSignature)signature, (Certificate[])chain, null, null, null, (int)0, (MakeSignature.CryptoStandard)MakeSignature.CryptoStandard.CADES);
            stp.close();
            reader.close();
            byte[] byArray = signPDFData.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (signPDFData != null) {
                try {
                    signPDFData.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static void sign(String resultPDF, String password, String keyStorePath, String signPdfSrc, String signImage, int signPage, float x, float y) throws Exception {
        byte[] fileData = PDFSign.sign(password, keyStorePath, signPdfSrc, signImage, signPage, x, y);
        FileOutputStream f = new FileOutputStream(new File(resultPDF));
        f.write(fileData);
        f.close();
    }

    public static Map<String, String> initData() {
        String secondSignature = "\u5f20\u4eae";
        String secondPartyIDNo = "330127199611154184";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String secondSignatureDate = format.format(new Date());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("contactNo", "C-SH-0001");
        data.put("practitionerNo", "YDSH00127");
        data.put("subsystem", "\u62b1\u4e00");
        data.put("practitioner", secondSignature);
        data.put("idNo", secondPartyIDNo);
        data.put("residentAddress", "\u4e0a\u6d77\u5e02\u6d66\u4e1c\u65b0\u533a\u5f20\u6768\u8def560\u53f7\u4e2d\u878d\u6052\u745e\u56fd\u9645\u897f\u697c1706\u5ba4");
        data.put("mobileNo", "13661741633");
        data.put("firstParty", "\u4e0a\u6d77\u94f6\u76fe\u4fdd\u9669\u7ecf\u7eaa\u6709\u9650\u516c\u53f8");
        data.put("firstPartyResponer", "\u4e0a\u6d77\u94f6\u76fe\u4fdd\u9669\u7ecf\u7eaa\u6709\u9650\u516c\u53f8");
        data.put("firstPartyAddress", "\u4e0a\u6d77\u5e02\u6d66\u4e1c\u65b0\u533a\u5f20\u6768\u8def560\u53f7\u4e2d\u878d\u6052\u745e\u56fd\u9645\u897f\u697c1706\u5ba4");
        data.put("secondParty", secondSignature);
        data.put("secondPartyIDNo", secondPartyIDNo);
        data.put("secondPartyAddress", "\u4e0a\u6d77\u5e02\u6d66\u4e1c\u65b0\u533a\u5f20\u6768\u8def560\u53f7\u4e2d\u878d\u6052\u745e\u56fd\u9645\u897f\u697c1706\u5ba4");
        data.put("secondMobileNo", "1366668888");
        data.put("secondSubsystemOwner", "\u9648\u6b22\u6b22");
        data.put("secondSubsystemSignature", "\u9648\u6b22\u6b22");
        data.put("secondSubsystemIDNo", "330127199611156403");
        data.put("secondSubsystemAddress", "\u4e0a\u6d77\u5e02\u6d66\u4e1c\u65b0\u533a\u5f20\u6768\u8def560\u53f7\u4e2d\u878d\u6052\u745e\u56fd\u9645\u897f\u697c1706\u5ba4");
        data.put("secondSubsystemMobileNo", "1366668888");
        data.put("secondMentor", "\u9648\u6b22\u6b22");
        data.put("secondMentorIDNo", "330127199611158003");
        data.put("secondMentorAddress", "\u4e0a\u6d77\u5e02\u6d66\u4e1c\u65b0\u533a\u5f20\u6768\u8def560\u53f7\u4e2d\u878d\u6052\u745e\u56fd\u9645\u897f\u697c1706\u5ba4");
        data.put("secondMentorMobileNo", "1366668888");
        data.put("contactYear", "2120");
        data.put("contactMonth", "12");
        data.put("contactDay", "16");
        data.put("secondParty801", secondSignature);
        data.put("secondBirthYear801", "1989");
        data.put("secondBirthMonth801", "10");
        data.put("secondBirthDay801", "09");
        data.put("secondPartyIDNo801", secondPartyIDNo);
        data.put("secondPartyPermanentResidenceAddress", "\u4e0a\u6d77\u5e02\u6d66\u4e1c\u65b0\u533a\u5f20\u6768\u8def560\u53f7\u4e2d\u878d\u6052\u745e\u56fd\u9645\u897f\u697c1706\u5ba4");
        data.put("secondPartyAddress801", "\u4e0a\u6d77\u5e02\u6d66\u4e1c\u65b0\u533a\u5f20\u6768\u8def560\u53f7\u4e2d\u878d\u6052\u745e\u56fd\u9645\u897f\u697c1706\u5ba4");
        data.put("secondMobileNo801", "1366668888");
        data.put("secondPractitionerRegNo", "26961531000080062020000314");
        data.put("secondEmail", "2120@163.com");
        data.put("secondWorkingExperience1", "\u5ae6\u5a255\u53f7\u767b\u6708");
        data.put("secondWorkingPosition1", "\u9879\u76ee\u603b\u5de5");
        data.put("secondWorkingPeriod1", "2016.12~\u81f3\u4eca");
        data.put("secondWorkingExperience2", "\u5ae6\u5a254\u53f7\u767b\u6708");
        data.put("secondWorkingPosition2", "\u59ff\u6001\u8c03\u6574\u5de5\u7a0b\u5e08");
        data.put("secondWorkingPeriod2", "2014.11~2016.10");
        data.put("secondWorkingExperience3", "\u5ae6\u5a253\u53f7\u767b\u6708");
        data.put("secondWorkingPosition3", "\u52a8\u529b\u5de5\u7a0b\u6267\u638c");
        data.put("secondWorkingPeriod3", "2012.03~2014.10");
        data.put("secondWorkingExperience4", "\u5ae6\u5a252\u53f7\u767b\u6708");
        data.put("secondWorkingPosition4", "\u56fa\u6001\u71c3\u6599\u51b7\u51cc\u6280\u5e08");
        data.put("secondWorkingPeriod4", "2010.07~2012.01");
        data.put("secondBankAccount", secondSignature);
        data.put("secondBankAccountOpening", "\u4e0a\u6d77\u5e02\u5de5\u5546\u94f6\u884c\u9f50\u9f50\u54c8\u5c14\u8def\u652f\u884c");
        data.put("secondBankAccountID", "6222001001234567890");
        data.put("secondMentor802", "\u9648\u6b22\u6b22");
        data.put("secondIntroducer", "\u9648\u6b22\u6b22");
        data.put("secondMentorIDNo801", "330127199611151346");
        data.put("secondIntroducerIDNo", "330127199611156403");
        data.put("secondEffectiveYear", "2120");
        data.put("secondEffectiveMonth", "12");
        data.put("secondEffectiveDay", "30");
        data.put("secondParty802", secondSignature);
        data.put("secondMentor801", "\u9648\u6b22\u6b22");
        data.put("secondSubsystem", "\u62b1\u4e00");
        data.put("secondSubsystemNo", "HUGONE");
        data.put("secondSubsystemManager", "\u9648\u6b22\u6b22");
        data.put("secondSubsystemMaster", "\u9648\u6b22\u6b22");
        data.put("secondBranchManager", "\u738b\u5b50\u5e37");
        data.put("secondBranchMaster", "\u738b\u5b50\u5e37");
        data.put("secondCenterHr", "EVEN");
        data.put("secondCenterCEO", "SHARON");
        data.put("secondSignatureDate1001", secondSignatureDate);
        data.put("secondParty1201", secondSignature);
        data.put("secondSignatureDate1201", secondSignatureDate);
        data.put("secondParty1401", secondSignature);
        data.put("secondSignatureDate1401", secondSignatureDate);
        data.put("secondParty1601", secondSignature);
        data.put("secondPartyIDNo1601", secondPartyIDNo);
        data.put("secondSignatureDate1601", secondSignatureDate);
        return data;
    }

    public static Map<String, String> initImage() {
        HashMap<String, String> images = new HashMap<String, String>();
        images.put("secondPersonerPicture", "D:\\pcs12\\secondPersonerPicture.png");
        images.put("yindunESignature1001", "D:\\pcs12\\\u4e0a\u6d77\u94f6\u76fe\u4fdd\u9669\u7ecf\u7eaa\u6709\u9650\u516c\u53f8.png");
        images.put("yindunESignature1201", "D:\\pcs12\\\u4e0a\u6d77\u94f6\u76fe\u4fdd\u9669\u7ecf\u7eaa\u6709\u9650\u516c\u53f8.png");
        images.put("yindunESignature1401", "D:\\pcs12\\\u4e0a\u6d77\u94f6\u76fe\u4fdd\u9669\u7ecf\u7eaa\u6709\u9650\u516c\u53f8.png");
        images.put("secondSignature1001", "D:\\pcs12\\signature.png");
        images.put("secondSignature1201", "D:\\pcs12\\signature.png");
        images.put("secondSignature1401", "D:\\pcs12\\signature.png");
        images.put("secondSignature1601", "D:\\pcs12\\signature.png");
        images.put("secondIDFrontPageImage", "D:\\pcs12\\IDFront.jpg");
        images.put("secondIDBackPageImage", "D:\\pcs12\\IDback.jpg");
        images.put("secondBankCardImage", "D:\\pcs12\\bank.jpg");
        images.put("secondIDType1", "D:\\pcs12\\checked.png");
        images.put("secondIDType2", "D:\\pcs12\\uncheck.png");
        images.put("secondIDType3", "D:\\pcs12\\uncheck.png");
        images.put("secondIDType4", "D:\\pcs12\\uncheck.png");
        images.put("secondPersonalStatement1", "D:\\pcs12\\checked.png");
        images.put("secondPersonalStatement2", "D:\\pcs12\\uncheck.png");
        images.put("secondPersonalStatement3", "D:\\pcs12\\uncheck.png");
        images.put("secondPersonalStatement4", "D:\\pcs12\\uncheck.png");
        images.put("secondPersonalStatement5", "D:\\pcs12\\uncheck.png");
        images.put("secondPersonalStatement5", "D:\\pcs12\\checked.png");
        images.put("secondPosition1", "D:\\pcs12\\checked.png");
        images.put("secondPosition2", "D:\\pcs12\\uncheck.png");
        images.put("secondPosition3", "D:\\pcs12\\uncheck.png");
        images.put("secondPosition4", "D:\\pcs12\\uncheck.png");
        images.put("secondPosition5", "D:\\pcs12\\uncheck.png");
        images.put("secondPosition6", "D:\\pcs12\\uncheck.png");
        return images;
    }

    public static void main(String[] args) throws Exception {
        String templatePDF = "D:\\pcs12\\tplImageNew.pdf";
        String templateResultPDF = "D:\\\\pcs12\\\\resultData.pdf";
        Map<String, String> dt = PDFSign.initData();
        Map<String, String> img = PDFSign.initImage();
        PDFTemplate.generatePDF(templatePDF, templateResultPDF, dt, img);
        String signSourcePDF = templateResultPDF;
        String signImage = "D:\\pcs12\\\u4e0a\u6d77\u94f6\u76fe\u4fdd\u9669\u7ecf\u7eaa\u6709\u9650\u516c\u53f8.png";
        String signResultPDF = "D:\\\\pcs12\\\\signedYD.pdf";
        String password = "UC645YlB";
        String keyStorePath = "C:\\Users\\Simon Cheng\\Downloads\\4929078_m.zuihuibi.cn_tomcat\\4929078_m.zuihuibi.cn.pfx";
        float x = 450.0f;
        float y = 150.0f;
        PDFSign.sign(signResultPDF, password, keyStorePath, signSourcePDF, signImage, 13, x, y);
    }
}

