package com.yd.rmi.ali.ossinterf.service;

import com.aliyun.oss.model.*;

import java.io.File;
import java.util.List;

public interface AliOssInterfService {

	public void initAttribute();
    /**
     * 初始化相关链接参数
     * @param endpoint
     * @param accessKeyId
     * @param accessKeySecret
     */
	public void initAttribute(String endpoint,String accessKeyId,String accessKeySecret);
    
    /**
     * 判断存储空间是否存在
     * @param bucketName 存储空间名
     * @return
     */
	public boolean doesBucketExist(String bucketName);
	
	/**
	 * 获取存储空间访问权限
	 * @param bucketName 存储空间名
	 * @return
	 */
	public AccessControlList getBucketAcl(String bucketName);
	
	/**
	 * 创建存储空间
	 * @param bucketName 存储空间名
	 * @param cannedACL 访问权限
	 */
	public void createBucket(String bucketName, CannedAccessControlList cannedACL);
	
	/**
	 * 设置存储空间访问权限
	 * @param bucketName 存储空间名
	 * @param cannedACL 访问权限
	 */
	public void setBucketAcl(String bucketName,CannedAccessControlList cannedACL);
	
	/**
	 * 列出当前访问域名下的所有存储空间
	 * @return
	 */
	public BucketList listBuckets();

	/**
	 * 判断对象是否存在
	 * @param bucketName 存储空间名
	 * @param key 对象名
	 * @return
	 */
	public boolean doesObjectExist(String bucketName,String key);
	
	/**
	 * 获取对象的访问权限
	 * @param bucketName 存储空间名
	 * @param key 对象名
	 * @return
	 */
	public ObjectAcl getObjectAcl(String bucketName, String key);
	
	/**
	 * 上传文件
	 * @param bucketName 存储空间名
	 * @param key 对象名
	 * @param file 文件
	 */
	public void putObject(String bucketName,String key,File file);
	
	/**
	 * 设置对象访问权限
	 * @param bucketName 存储空间名
	 * @param key 对象名
	 * @param cannedACL 访问权限
	 */
	public void setObjectAcl(String bucketName,String key, CannedAccessControlList cannedACL);
	
	/**
	 * 下载对象
	 * @param bucketName 存储空间名
	 * @param key 对象名
	 * @return
	 */
	public OSSObject getObject(String bucketName, String key);
	
	/**
	 * 列出当前访问域名下的所有对象
	 * @param bucketName 存储空间名
	 * @param prefix 
	 * @return
	 */
	public ObjectListing listObjects(String bucketName, String prefix);
	
	/**
	 * 获取对象外网访问URL
	 * @param bucketName 存储空间名
	 * @param key 对象名
	 * @return
	 */
	public String generateUrl(String bucketName,String key);
	
	/**
	 * 删除对象
	 * @param bucketName 存储空间名
	 * @param keys 对象名列表
	 */
	public void deleteObjects(String bucketName,List<String> keys);
}
