package com.yd.dal.service.customer.impl;

import com.yd.dal.entity.customer.AclPractitionerSubordinateSystem;
import com.yd.dal.entity.customer.practitioner.PractitionerSubordinateInfo;
import com.yd.dal.entity.customer.practitioner.SubordinateSystemMemberInfoE;
import com.yd.dal.mapper.customer.AclPractitionerSubordinateSystemMapper;
import com.yd.dal.service.customer.AclPractitionerSubordinateSystemDALService;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service("aclPractitionerSubordinateSystemDALService")
public class AclPractitionerSubordinateSystemDALServiceImpl implements AclPractitionerSubordinateSystemDALService {

    @Resource
    private AclPractitionerSubordinateSystemMapper aclPractitionerSubordinateSystemMapper;
    /**
     * 根据体系ID获取体系相关信息
     * @param subordinateId 体系ID
     * @return
     */
    @Override
    public PractitionerSubordinateInfo findSubordinateInfo(Long subordinateId) {
        PractitionerSubordinateInfo subordinateInfo = null;
        if(subordinateId != null){
            subordinateInfo = aclPractitionerSubordinateSystemMapper.findSubordinateInfo(subordinateId);
        }
        return subordinateInfo;
    }

    @Override
    public AclPractitionerSubordinateSystem findByPractitionerId(Long practitionerId) {
        return aclPractitionerSubordinateSystemMapper.findByPractitionerId(practitionerId);
    }

    @Override
    public List<AclPractitionerSubordinateSystem> findByOwnerPractitionerId(Long practitionerId) {
        return aclPractitionerSubordinateSystemMapper.findByOwnerPractitionerId(practitionerId);
    }
    @Override
    public List<AclPractitionerSubordinateSystem> findByOwner(Long practitionerId) {
        return aclPractitionerSubordinateSystemMapper.findByOwner(practitionerId);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public PractitionerSubordinateInfo findByOwnerE(String practitionerId) {
        return aclPractitionerSubordinateSystemMapper.findByOwnerE(practitionerId);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<SubordinateSystemMemberInfoE> findStatisticsE(String subordinateIdForEGolden, Integer time) {
        return aclPractitionerSubordinateSystemMapper.findStatisticsE(subordinateIdForEGolden,time);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<SubordinateSystemMemberInfoE> findStatisticsEBymobileList(List<String> mobileNoList, Integer time) {
        return aclPractitionerSubordinateSystemMapper.findStatisticsEBymobileList(mobileNoList, time);
    }

    @Override
    public AclPractitionerSubordinateSystem findById(Long subsystemId) {
        return aclPractitionerSubordinateSystemMapper.selectByPrimaryKey(subsystemId);
    }

    @Override
    public List<AclPractitionerSubordinateSystem> findByDeptId(Long deptId) {
        return aclPractitionerSubordinateSystemMapper.findByDeptId(deptId);
    }

    @Override
    public List<AclPractitionerSubordinateSystem> findByInsurerBranchId(Long insurerBranchId) {
        return aclPractitionerSubordinateSystemMapper.findByInsurerBranchId(insurerBranchId);
    }

    @Override
    public List<AclPractitionerSubordinateSystem> findDeptIdAndInsureBranchIdNull(Long insurerId) {
        return aclPractitionerSubordinateSystemMapper.findDeptIdAndInsureBranchIdNull(insurerId);
    }

    @Override
    public List<AclPractitionerSubordinateSystem> findDeptIdNotNull(Long insurerId) {
        return aclPractitionerSubordinateSystemMapper.findDeptIdNotNull(insurerId);
    }

    @Override
    public List<Long> getLongs(PractitionerSubordinateInfo practitionerSubordinateInfo) {
        // 经纪人管理 组织架构更新保存调整
        Long s1Id = practitionerSubordinateInfo.getS1Id(),s2Id = practitionerSubordinateInfo.getS2Id(),s3Id = practitionerSubordinateInfo.getS3Id();
        List<AclPractitionerSubordinateSystem> childOrg = new ArrayList<>();
        List<AclPractitionerSubordinateSystem> allList = new ArrayList<>();
        List<Long> longList = new ArrayList<>();

        if("3".equals(practitionerSubordinateInfo.getSystemFlag())){
            practitionerSubordinateInfo.setSubordinateSystemId(s1Id);
        }
        if("4".equals(practitionerSubordinateInfo.getSystemFlag())){
            practitionerSubordinateInfo.setSubordinateSystemId(s2Id);
        }
        if("5".equals(practitionerSubordinateInfo.getSystemFlag())){
            practitionerSubordinateInfo.setSubordinateSystemId(s3Id);
        }
        if(null != practitionerSubordinateInfo.getSubordinateSystemId()){
            //1，总公司下的体系
            if(null == practitionerSubordinateInfo.getInsurerBranchId()  && null == practitionerSubordinateInfo.getDeptId()){
                allList = this.findDeptIdAndInsureBranchIdNull(practitionerSubordinateInfo.getInsurerId() == null ? 888 : practitionerSubordinateInfo.getInsurerId());
            }
            //2,总公司营业部下的体系
            if(null == practitionerSubordinateInfo.getInsurerBranchId()  && null != practitionerSubordinateInfo.getDeptId()) {
                allList = this.findDeptIdNotNull(practitionerSubordinateInfo.getInsurerId() == null ? 888 : practitionerSubordinateInfo.getInsurerId());
            }
            //3,分公司下的体系
            if(null != practitionerSubordinateInfo.getInsurerBranchId()  && null == practitionerSubordinateInfo.getDeptId()){
                allList = this.findByInsurerBranchId(practitionerSubordinateInfo.getInsurerBranchId());
            }
            //4，分公司营业部下的体系
            if(null != practitionerSubordinateInfo.getInsurerBranchId()  && null != practitionerSubordinateInfo.getDeptId()){
                allList = this.findByDeptId(practitionerSubordinateInfo.getDeptId());
            }
            //5，根据父节点获取到所有子节点
            this.orgRecursion(childOrg,allList, practitionerSubordinateInfo.getSubordinateSystemId());
        }
        if(childOrg.size() > 0) {
            for (AclPractitionerSubordinateSystem org : childOrg) {
                longList.add(org.getId());
            }
        }
        if(null != practitionerSubordinateInfo.getSubordinateSystemId()){
            longList.add(practitionerSubordinateInfo.getSubordinateSystemId());
        }
        return longList;
    }
    /**
     * 递归获取某个父节点下面的所有子节点
     * @param childOrg 要返回的结果
     * @param allList  数据库查询出来的所有集合
     * @param pid      父id
     */
    @Override
    public void orgRecursion(List<AclPractitionerSubordinateSystem> childOrg,List<AclPractitionerSubordinateSystem> allList, Long pid) {
        if(null != allList && allList.size() > 0 ){
            for (AclPractitionerSubordinateSystem org : allList) {
                if (org.getParentId() != null && org.getParentId().equals(pid)) {
                    //遍历出父id等于参数的id，add进子节点集合
                    //递归遍历下一级
                    orgRecursion(childOrg,allList, org.getId());
                    childOrg.add(org);
                }
            }
        }
    }

    @Override
    public List<AclPractitionerSubordinateSystem> findAll() {
        return aclPractitionerSubordinateSystemMapper.findAll();
    }
}
