package com.yd.dal.entity.tencent;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * ag_ten_interf_record
 * @author 
 */
@Data
public class TenInterfRecord implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * 接口类型:TOKEN;ACCESS_TOKEN;JSAPI_TICKET
     */
    private String interfType;

    /**
     * 公众号的唯一标识
     */
    private String appid;

    /**
     * 公众号的appsecret
     */
    private String secret;

    /**
     * authorize接口返回的code
     */
    private String code;

    /**
     * access_token接口时固定为authorization_code
     */
    private String grantType;

    /**
     * access_token接口，服务开发方的appid
     */
    private String componentAppid;

    /**
     * access_token接口，服务开发方的access_token
     */
    private String componentAccessToken;

    /**
     * getticket接口时为wx_card
     */
    private String iType;

    /**
     * access_token接口返回：接口调用凭证
     */
    private String accessToken;

    /**
     * access_token接口返回：接口调用凭证超时时间，单位（秒）
     */
    private Long expiresIn;

    /**
     * access_token接口返回：用户刷新access_token
     */
    private String refreshToken;

    /**
     * access_token接口返回：用户唯一标识
     */
    private String openid;

    /**
     * access_token接口返回：用户授权的作用域，使用逗号（,）分隔
     */
    private String iScope;

    /**
     * getticket接口返回
     */
    private String errcode;

    /**
     * getticket接口返回
     */
    private String errmsg;

    /**
     * getticket接口返回
     */
    private String ticket;

    /**
     * 创建时间
     */
    private Date createdAt;

    private static final long serialVersionUID = 1L;
}