package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_practitioner_setting
 * @author 
 */
@Data
public class AclPractitionerSetting implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_practitioner.id
     */
    private Long practitionerId;

    /**
     * FK ag_md_drop_options.id,经纪人:1产险、2寿险、3商业
     */
    private Long practitionerTypeId;

    /**
     * FK ag_md_drop_options.id,经纪人分成5个级别 ： S2 、S1、 A3、 A2、 A1,level决定佣金比例
     */
    private Long practitionerLevel;

    /**
     * 比例有效期起日
     */
    private Date levelStartDate;

    /**
     * 比例有效期终日
     */
    private Date levelEndDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 建置日
     */
    private Date createdAt;

    /**
     * 建置者
     */
    private Long createdBy;

    /**
     * 更新日
     */
    private Date updatedAt;

    private Long updatedBy;

    private static final long serialVersionUID = 1L;
}