package com.yd.api.customer.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.common.base.Strings;
import com.yd.api.customer.vo.register.RegisterRequestVO;
import com.yd.api.customer.vo.register.RegisterResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclCustomer;
import com.yd.dal.service.customer.AclCustomerDALService;
import com.yd.dal.service.customer.CustomerDALService;
import com.yd.util.EncryptUtil;
import com.yd.util.config.ZHBErrorConfig;
import com.yd.util.deshandler.DESTypeHandler;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.github.pagehelper.PageInfo;
import com.yd.api.customer.vo.CustomerFortuneRequestVO;
import com.yd.api.customer.vo.CustomerFortuneResponseVO;
import com.yd.api.customer.vo.CustomerQueryRequestVO;
import com.yd.api.customer.vo.CustomerQueryResponseVO;
import com.yd.api.customer.vo.CustomerVO;
import com.yd.dal.entity.customer.Customer;
import com.yd.dal.entity.customer.CustomerFortune;

@Service("customerServiceImpl")
public class CustomerServiceImpl implements CustomerService{

	@Autowired
    private CustomerDALService customerServiceDA;

	@Autowired
    private AclCustomerDALService aclCustomerDALService;

	@Override
	public List<CustomerVO> listAllCustomer() {
		List<CustomerVO> listTo =new ArrayList<>();
		List<Customer> list ;
		list = customerServiceDA.listAllCustomers();
		CustomerVO oneDestVO;
    	for(Customer oneSrc:list)
    	{
    		oneDestVO = new CustomerVO();
    		BeanUtils.copyProperties(oneSrc, oneDestVO);
    		listTo.add(oneDestVO);
    	}
		return listTo;
	}
	
	@Override
	public CustomerQueryResponseVO findByPage(CustomerQueryRequestVO customerQueryRequestVO)
	{
		CustomerQueryResponseVO customerQueryResponseVO = new CustomerQueryResponseVO();
		
		PageInfo<Customer> page = customerQueryRequestVO.getPage();

		PageInfo<Customer> list = customerServiceDA.findByPage(page.getPageNum(), page.getSize());
  	
    	customerQueryResponseVO.setCustomerId(customerQueryRequestVO.getCustomerId());
    	
    	customerQueryResponseVO.setCustomerPage(list);
    	
		return customerQueryResponseVO;
	}

	@Override
	public CustomerFortuneResponseVO selectByCustomerId(CustomerFortuneRequestVO request) {
		
		CustomerFortuneResponseVO customerQueryResponseVO = new CustomerFortuneResponseVO();
		Long customerId = request.getCustomerId();
		
		PageInfo<CustomerFortune> page = request.getPage();

		PageInfo<CustomerFortune> list = customerServiceDA.selectByCustomerId(customerId, page.getPageNum(), page.getSize());
  	
    	customerQueryResponseVO.setCustomerId(customerId);
    	
    	customerQueryResponseVO.setCustomerPage(list);
    	
		return customerQueryResponseVO;
	}

	@Override
	public RegisterResponseVO register(RegisterRequestVO requestVO) {
		RegisterResponseVO registerResponseVO = new RegisterResponseVO();
		String mobileNo = requestVO.getMobileNo();
		String checkResult = paramCheck(mobileNo);
		//入参校验
		if(Strings.isNullOrEmpty(checkResult)){
			String accountId = createAccountId(mobileNo);
			List<AclCustomer> aclCustomerList = aclCustomerDALService.findByLogin(mobileNo);
			if(aclCustomerList.isEmpty()){
				AclCustomer aclCustomer = new AclCustomer();
				aclCustomer.setRole(2);//1= Staff 2=Customer 3=Partner
				aclCustomer.setAccountId(accountId);
				aclCustomer.setLogin(mobileNo);
				aclCustomer.setMobileNo(mobileNo);
				aclCustomer.setPassword(EncryptUtil.encrypt(requestVO.getPassword(),null));
				aclCustomer.setEmail(requestVO.getEmail());
				aclCustomer.setCusLevel(1);
				aclCustomer.setName(requestVO.getName());
				aclCustomer.setIsActive(1);
				aclCustomer.setRoleId(3L);
				aclCustomer.setWithdrawType(0);
				aclCustomer.setCreatedAt(new Date());
				aclCustomer.setCreatedBy(-1L);
				aclCustomer.setUpdatedAt(new Date());
				aclCustomer.setUpdatedBy(-1L);
				aclCustomer.setChannelReferralRateId(3L);
				aclCustomerDALService.save(aclCustomer);
				//202003对新注册的客户还需保存至ag_mkt_leads_pool
//				saveLeadsPool(aclCustomer);
				registerResponseVO.setCustomerId(aclCustomer.getId());
				registerResponseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
			}else{
				String [] params = {mobileNo};
				registerResponseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("630002",params)));
				registerResponseVO.setCustomerId(aclCustomerList.get(0).getId());
			}
		}else{
			registerResponseVO.setCommonResult(new CommonResult(false,checkResult));
		}
		return registerResponseVO;
	}

	private String createAccountId(String mobileNo) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String sub = null;
		if(mobileNo != null && !"".equals(mobileNo)){
			sub = mobileNo.substring(mobileNo.length()-6);
		}
		return "C_"+sub+"_"+sdf.format(new Date());
	}

	private String paramCheck(String mobileNo) {
		if(Strings.isNullOrEmpty(mobileNo)){
			String[] params ={"mobileNo"};
			return ZHBErrorConfig.getErrorInfo("610002", params);
		}else{
			if(mobileNo.length() != 11 || !mobileNo.startsWith("1")){
				String[] params = {mobileNo};
				return ZHBErrorConfig.getErrorInfo("630001", params);
			}
		}
		return null;
	}
}

