/*
 * Decompiled with CFR 0.152.
 */
package com.libs.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDFTemplate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generatePDF(String templatePdfPath, String generatePdfPath, Map<String, String> data, Map<String, String> img) {
        OutputStream fos = null;
        ByteArrayOutputStream bos = null;
        PdfReader reader = null;
        PdfStamper ps = null;
        try {
            reader = new PdfReader(templatePdfPath);
            bos = new ByteArrayOutputStream();
            ps = new PdfStamper(reader, (OutputStream)bos);
            BaseFont bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            ArrayList<BaseFont> fontList = new ArrayList<BaseFont>();
            fontList.add(bf);
            AcroFields fields = ps.getAcroFields();
            fields.setSubstitutionFonts(fontList);
            if (data != null && data.size() > 0) {
                PDFTemplate.fillData(fields, data);
            }
            if (img != null && img.size() > 0) {
                PDFTemplate.addImage(ps, fields, img);
            }
            ps.setFormFlattening(true);
            ps.close();
            fos = new FileOutputStream(generatePdfPath);
            fos.write(bos.toByteArray());
            fos.flush();
            String string = generatePdfPath;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (reader != null) {
            reader.close();
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void fillData(AcroFields fields, Map<String, String> data) throws IOException, DocumentException {
        ArrayList<String> keys = new ArrayList<String>();
        Map formFields = fields.getFields();
        for (String key : data.keySet()) {
            if (!formFields.containsKey(key)) continue;
            String value = data.get(key);
            fields.setField(key, value);
            keys.add(key);
        }
        for (String itemKey : formFields.keySet()) {
            if (keys.contains(itemKey)) continue;
            fields.setField(itemKey, " ");
        }
    }

    private static void addImage(PdfStamper stamper, AcroFields forms, Map<String, String> img) {
        for (String key : img.keySet()) {
            String value = img.get(key);
            PDFTemplate.addImage(stamper, forms, key, value);
        }
    }

    private static void addImage(PdfStamper stamper, AcroFields forms, String field, String fieldValue) {
        try {
            List photograph = forms.getFieldPositions(field);
            if (photograph != null && photograph.size() > 0) {
                Rectangle rect = ((AcroFields.FieldPosition)photograph.get((int)0)).position;
                Image img = Image.getInstance((String)fieldValue);
                img.scaleToFit(rect.getWidth(), rect.getHeight());
                img.setBorder(2);
                img.setAbsolutePosition(((AcroFields.FieldPosition)photograph.get((int)0)).position.getLeft() + (rect.getWidth() - img.getScaledWidth()), ((AcroFields.FieldPosition)photograph.get((int)0)).position.getTop() - rect.getHeight());
                PdfContentByte cb = stamper.getOverContent(((AcroFields.FieldPosition)photograph.get((int)0)).page);
                cb.addImage(img);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        HashMap data = new HashMap();
        String fileName = "D:\\pcs12\\tplImage.pdf";
        String resultFile = "D:\\pcs12\\result.pdf";
        Map<String, String> dt = PDFTemplate.data();
        Map<String, String> img = PDFTemplate.image();
        PDFTemplate.generatePDF(fileName, resultFile, dt, img);
    }

    private static Map<String, String> data() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("year", "2120");
        data.put("marks", "2120\u6458\u8981\uff1a\u8fd9\u4e2a\u672c\u6765\u5c5e\u4e8es3 \u7684\u7279\u6027\uff0c\u4f46\u662f\u6211\u4eec\u5728\u5b9e\u9645\u4f7f\u7528\u7684\u8fc7\u7a0b\u4e2d\u80af\u5b9a\u4e0d\u60f3\u522b\u4eba\u76f4\u63a5\u53ef\u4ee5\u901a\u8fc7\u6d4f\u89c8\u5668\u6216\u8005http\u5c31\u53ef\u4ee5\u53ef\u4ee5\u6211\u4eec\u7684\u6587\u4ef6\u5185\u5bb9 \u8fd9\u4e2a\u5c5e\u4e8e\u5b89\u5168\u7684\u63a7\u5236\uff0c\u4ee5\u4e0b\u662f\u4e00\u4e2a\u5b9e\u8df5\u4ee5\u53ca\u4e00\u4e9b\u5b89\u5168\u63a7\u5236 \u4e00\u4e9b\u539f\u5219 \u4e0d\u80fd\u76f4\u63a5\u66b4\u9732minio \u8bbf\u95ee\u5230\u516c\u7f51\u73af\u5883\uff08\u53ef\u4ee5\u57fa\u4e8enginx\uff0c\u4ee5\u53ca\u53cd\u5411\u4ee3\u7406\u5de5\u5177\u89e3\u51b3\uff09 \u914d\u7f6e\u5408\u7406\u7684bucket \u7b56\u7565\uff0c\u53ef\u4ee5 \u9605\u8bfb\u5168\u6587\n");
        data.put("d", "2120\u56e0\u4e3a\u5f53\u524d\u5927\u5bb6\u4e3b\u6d41\u7684\u8fd8\u662f\u57fa\u4e8e\u524d\u540e\u7aef\u5206\u79bb\u7684\u6a21\u5f0f\u5f00\u53d1\u8f6f\u4ef6\uff0c\u7ec4\u4ef6+api \u5b9e\u73b0\u529f\u80fd\uff0c\u4f46\u662f\u5f88\u591a\u65f6\u5019\u597d\u591a\u79df\u6237\u5bf9\u4e8e\u529f\u80fd\u6709\u4e2a\u6027\u5316\u9700\u6c42\uff0c\u4f46\u662f\n\u7cfb\u7edf\u5728\u8bbe\u8ba1\u7684\u65f6\u5019\u56e0\u4e3a\u65f6\u95f4\u95ee\u9898+\u65e9\u671f\u8bbe\u8ba1\u95ee\u9898\u9020\u6210\u4e1a\u52a1\u6269\u5c55\u80fd\u529b\u6709\u70b9\u5dee\uff0c\u8fd8\u9700\u8981\u652f\u6301\u4e2a\u6027\u5316\u9700\u6c42\u5f00\u53d1\uff0c\u6240\u4ee5\u6211\u4eec\u53ef\u4ee5\u62c6\u5206\u6807\u51c6\u7248\u672c\n\u4ee5\u53ca\u81ea\u5b9a\u578b\u7248\u672c\uff0c\u540c\u65f6\u57fa\u4e8eminio \u63d0\u4f9b\u7684s3 \u7ba1\u7406\u6a21\u5f0f\uff0c\u5bf9\u4e8e\u4e0d\u540c\u7684\u79df\u6237\u521b\u5efa\u4e0d\u540c\u7684bucket\uff0c\u6807\u51c6\u7684\u4f7f\u7528\u6807\u51c6\u7248\uff0c\u8fd9\u6837\u5ba2\u6237\u5316\u5f00\u53d1\u5c31\u5f88\u7b80\u5355\n\u4e86\uff08\u7279\u6b8a\u573a\u666f\u9700\u8981\u4e2a\u6027\u5316\uff09\uff0c\u6b64\u65b9\u6848\u7684\u7f3a\u70b9\u4e5f\u6bd4\u8f83\u660e\u786e\uff1a\u7a7a\u95f4\u7684\u5360\u7528\uff0c\u4f46\u662f\u8fd8\u597d\u56e0\u4e3a\u524d\u540e\u7aef\u5206\u79bb\u7684\u6a21\u5f0f\u3002\u6bcf\u4e2a\u79df\u6237\u5360\u7528\u7684\u9759\u6001\u8d44\u6e90\u4e5f\u4e0d\u662f\n\u5f88\u5927\uff0c\u6838\u5fc3\u95ee\u9898\u662f\u5728\u7cfb\u7edf\u66f4\u65b0\u7684\u65f6\u5019\uff0c\u6211\u4eec\u53ef\u80fd\u9700\u8981\u5f15\u5bfc\u5ba2\u6237\u81ea\u5df1\u5347\u7ea7\u6216\u8005\u57fa\u4e8e\u5f3a\u5927\u7684ci/cd \u7cfb\u7edf\u8fdb\u884c\u6240\u6709\u79df\u6237\u7684\u7cfb\u7edf\u5347\u7ea7\uff08\u6784\u5efa\u5305\u7684\u5904\u7406\uff09\n\u4e2a\u4eba\u611f\u89c9\u597d\u5904\u4e5f\u662f\u5f88\u660e\u663e\u7684\uff0c\u5982\u679c\u6211\u4eec\u7684api \u4ee5\u53cawebsite \u5df2\u7ecf\u505a\u4e86\u6bd4\u8f83\u597d\u7684\u7248\u672c\u7ba1\u7406\uff0c\u7528\u6237\u5207\u6362\u7248\u672c\u4e5f\u5c31\u662f\u9759\u6001\u8d44\u6e90\u7684\u66ff\u6362\uff08\u76f4\u63a5\u57fa\u4e8es3 bucket\uff09\u3002\nsaas \u5e94\u7528\u7684\u529f\u80fd\u4e3b\u8981\u57fa\u4e8e\u5355\u9875\u9762\u7684\u6a21\u5f0f\u5f00\u53d1\u7684\u5e94\u7528\uff0c\u5728s3 \u4e2d\u7684\u5b58\u50a8\u5c31\u662fcss\uff0cjs \u4ee5\u53ca\u9759\u6001html \u9875\u9762\u3002\u8fd9\u6837\u7ba1\u7406\u8d77\u6765\u4e5f\u662f\u6bd4\u8f83\u7075");
        return data;
    }

    private static Map<String, String> image() {
        HashMap<String, String> images = new HashMap<String, String>();
        images.put("logo", "D:\\pcs12\\signature.png");
        return images;
    }
}

