package com.yd.dal.service.customer;

import com.yd.api.practitioner.vo.businessCard.Certificate;
import com.yd.api.practitioner.vo.businessCard.PractitionerBusinessCardResponseVO;
import com.yd.api.practitioner.vo.payscale.PayScaleInfo;
import com.yd.api.practitioner.vo.subordinate.TeamMemberDetail;
import com.yd.api.practitioner.vo.unionSales.UnionSalesPractitionerInfo;
import com.yd.dal.entity.customer.AclCustomer;
import com.yd.dal.entity.customer.AclPractitioner;
import com.yd.dal.entity.customer.practitioner.PractitionerBasicInfo;
import com.yd.dal.entity.customer.practitioner.PractitionerInfo;
import com.yd.dal.entity.customer.practitioner.PractitionerRankInfo;
import com.yd.dal.entity.practitioner.opportunity.OwnOpportunityInfo;
import com.yd.dal.entity.practitioner.opportunity.PlayerSalesActivityInfo;
import com.yd.dal.entity.practitioner.payscale.PayScaleBasicInfo;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service("aclPractitionerDALService")
public interface AclPractitionerDALService {
    /**
     * 通过customerId 和is_active 获取用户
     * @param customerId
     * @param i
     * @return
     */
    AclPractitioner findByCustomerIdIsActive(Long customerId, int i);

    /**
     * 线下--通过手机号码获取经纪人的基础信息
     * @param mobileNo
     * @return
     */
    PractitionerBasicInfo getPractitionerBasicInfoForOffline(String mobileNo);
    /**
     * 线上--通过手机号码获取经纪人的基础信息
     * @param mobileNo
     * @return
     */
    PractitionerBasicInfo getPractitionerBasicInfoForOnline(String mobileNo);

    /**
     * 线下--按照时间进行查询经纪人的排名统计信息
     * @param time 1-month,2-year
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfoForOffline(Integer time);

    /**
     * 线上--按照时间进行查询经纪人的排名统计信息
     * @param time 1-month,2-year
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfoForOnline(Integer time,Long practitionerTypeId,Integer platform,Integer type,List<String> mobileSpecials);
    
    /**
     * 查询经纪人个人的统计信息
     * @param time 1-month,2-year
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfo(Integer time,Long practitionerTypeId,Integer platform,Integer type,Integer practitionerId);

    /**
     * 线上--按照时间进行查询特殊人员的排名统计信息
     * @param mobileSpecials
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfoForSpecials(List<String> mobileSpecials,Integer time,Integer platform);

    /**
     * 经纪人基本信息查询
     * @param mobileNo
     * @return
     */
    PractitionerInfo findPractitionerInfoByLogin(String mobileNo);

    /**
     * 经纪人基本信息查询
     * @param paramList
     * @return
     */
    List<PractitionerInfo> findPractitionerInfoByPractitionerCode(List<String> paramList);

    /**
     * 通过经纪人id查找经纪人
     * @param practitionerId
     * @return
     */
    AclPractitioner findPractitionerById(Long practitionerId);

    /**
     * 经纪人查询自己的商机
     * @param practitionerId
     * @return
     */
    List<OwnOpportunityInfo> ownOpportunityQuery(Long practitionerId);
    void updatePractitioner(AclPractitioner practitioner);

    /**
     * 通过id数组查询
     * @param practitionerIdList
     * @return
     */
    List<AclPractitioner> findByIds(List<Long> practitionerIdList);

    /**
     * 通过团队长经纪人id查询团队旗下所有经纪人
     * @param practitionerId
     * @return
     */
    List<AclPractitioner> findForSubordinateIdByPractitionerId(Long practitionerId);

    /**
     * 通过团队长经纪人id查询团队中组员的销售活动量(跟进分数,除去以失败的跟进)
     * @param practitionerId
     * @return
     */
    List<PlayerSalesActivityInfo> playerSalesActivityQuery(Long practitionerId, Long optionsId);
    /**
     * 根据体系id查询经纪人
     * @param subordinateSystemId 体系id
     * @return
     */
    List<AclPractitioner> findBySubordinateSystemId(Long subordinateSystemId,String systemType);

    /**
     * 更具经纪人id查询该经纪人手机号码
     * @param practitionerId 经纪人id
     * @return 查询结果
     */
    String findMobileNoByPractitionerId(Long practitionerId);

    /**
     * EGolden -- 根据手机号码查询经纪人的基本信息
     * @param mobileNo 手机号码
     * @return 查询结果
     */
    PractitionerBasicInfo findByMobileNoE(String mobileNo);

    /**
     * 根据id查询经纪人信息
     * @param practitionerId 经纪人id
     * @return 查询结果
     */
    AclPractitioner findById(Long practitionerId);

    /**
     * EGolden -- 根据practitionerId和时间段查询
     * @param practitionerIdEG 经纪人id
     * @param time 时间
     * @return 返回结果
     */
    PractitionerRankInfo getPractitionerRankInfoByPractitionerIdEG(String practitionerIdEG, Integer time);

    /**
     * YD -- 根据practitionerId和时间段查询
     * @param practitionerId 经纪人id
     * @param time 时间
     * @return 返回结果
     */
    PractitionerRankInfo getPractitionerRankInfoByPractitionerIdYD(Long practitionerId, Integer time,Integer platform);

    /**
     * eGolden -- 根据经纪人id获取薪资表列表
     * @param practitionerIdEG 经纪人id
     * @return 结果
     */
    List<PayScaleInfo> findPayScaleByPractitionerEG(String practitionerIdEG);

    /**
     * 查询经纪人薪资文件路径
     * @param monShId 流水号
     * @return 结果
     */
    PayScaleBasicInfo findFilePathByMonShId(Integer monShId);

    /**
     * 根据EGolden查询
     * @param practitionerIdEG id
     * @return 返回
     */
    PractitionerBasicInfo findByIdEG(String practitionerIdEG);

    /**
     * 通过指派经纪人id,查询经纪人详情
     * @param leadsAssignedId
     * @return
     */
    AclPractitioner findPractitionerByLeadsAssignedId(Long leadsAssignedId);

    /**
     * 查询所有经纪人
     * @return 结果
     */
    List<AclPractitioner> findAll();

    int isTeamLeader(Long practitionerId);

    List<Long> queryTeamAllPractitionerId(Long practitionerId,Integer isActive);

    List<Long> queryMentoredByPractitionerId(Long practitionerId);

    void save(AclPractitioner practitioner);

    PractitionerInfo findPractitionerInfoByPractitionerId(Long practitionerId);

    List<TeamMemberDetail> queryTeamMemberDetailList(List<Long> practitionerIdList);

    List<String> findLeaveOfficeByPractitionerId(Long practitionerId);

    /**
     * 查询所有寿险经纪人
     * @return
     */
    List<AclPractitioner> queryAllLifePractitioner();

    List<PractitionerInfo> findPractitionerInfoByNameList(List<String> nameList);

    List<PractitionerInfo> findPractitionerInfoByMobileList(List<String> mobileList);

    List<PractitionerInfo> findPractitionerInfoByIdList(List<Long> idList);
    
    List<PractitionerInfo> findPractitionerInfoById(Long practitionerId);

    List<PayScaleInfo> queryEGHistorySalaryPDFByPractitionerId(Long practitionerId);

    /**
     水平越权处理，从token中获取当前用户（手机号），然后根据客户id查看是否有权限，查不到数据则说明没有权限
     */
    List<AclCustomer> getAclCustomers(Long practitionerId,Long flag);
    List<TeamMemberDetail> queryTeamMemberDetailRaiseList(List<Long> practitionerIdList);
    /**
     * 通过经纪人id查找经纪人
     * @param practitionerId
     * @return
     */
    List<AclPractitioner> findPractitionerByRaise(Long practitionerId);
    
    /**
     * 通过联合销售ID查询联合销售经纪人信息列表
     * @param unionSalesId 联合销售ID
     * @param unionSalesPractitionerId 联合销售经纪人ID
     * @return List<UnionSalesPractitionerInfo> 业务对象列表
     * @author Yan Wenyang
     */
    List<UnionSalesPractitionerInfo> findUnionSalesPractitionerByUnionSalesId(Long unionSalesId, Long unionSalesPractitionerId);
    
    /**
     * 更新联合销售经纪人信息
     * @param unionSalesPractitionerId 联合销售经纪人ID
     * @param ossPathImg 签署图片
     * @param singX 签署位置X
     * @param singY 签署位置Y
     * @param signStatus 签署状态
     * @return void
     * @author Yan Wenyang
     */
	void updateUnionSalesPractitioner(Long unionSalesPractitionerId, String ossPathImg, int singX, int singY, String signStatus);
	
	/**
	 * 更新联合销售信息
	 * @param unionSalesId 联合销售ID
	 * @param ossPath 签署文件
	 * @param signStatus 签署状态
     * @return void
     * @author Yan Wenyang
	 */
	void updateUnionSales(Long unionSalesId, String ossPath, String signStatus);

    Map<Long, AclPractitioner> findAllMap();

    /**
     * 经纪人名片
     * @param practitionerId
     * @return List<PractitionerBusinessCardResponseVO>
     * @author Yan Wenyang
	 */
    List<PractitionerBusinessCardResponseVO> businessCard(Long practitionerId);

    /**
     * 经纪人专业/荣誉证照
     * @param List<Long>
     * @return List<Certificate>
     * @author Yan Wenyang
	 */
    List<Certificate> findCertificate(List<Long> certIdList);
}
