package com.yd.dal.entity.customer;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
    * 保险公司分公司/营业部
    */
@Data
public class AclInsurerBranch implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
    * serial id
    */
    private Long id;

    /**
    * 分公司/营业部代码
    */
    private String branchCode;

    /**
    * FK ag_acl_insurer.id
    */
    private Long insurerId;

    /**
    * 保险公司名称
    */
    private String insurerName;

    /**
    * 分公司/营业部名称
    */
    private String branchName;

    /**
    * 0=No, 1=Yes
    */
    private Integer isActive;

    /**
    * 有效起日
    */
    private Date effectiveStartDate;

    /**
    * 有效终日
    */
    private Date effectiveEndDate;

    /**
    * 联系人
    */
    private String contactName;

    /**
    * 联系电话
    */
    private String contactNo;

    /**
    * 分公司地址
    */
    private String address;

    /**
    * 分公司电子印章
    */
    private String electronicTaxSeal;

    /**
    * 备注
    */
    private String remark;

    private Date createdAt;

    private Long createdBy;

    private Date updatedAt;

    private Long updatedBy;
}