package com.yd.api.agms.vo.fortune;

import com.yd.api.result.CommonResult;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xxy
 */
public class FortunePayoutBatchQueryResponseVO {

    private List<PayoutBatchInfo> payoutBatchInfos;
    private CommonResult commonResult;

    /**
     * 获取
     *
     * @return payoutBatchInfos
     */
    public List<PayoutBatchInfo> getPayoutBatchInfos() {
        return this.payoutBatchInfos;
    }

    /**
     * 设置
     *
     * @param payoutBatchInfos
     */
    public void setPayoutBatchInfos(List<String> payoutBatchInfos) {
        this.payoutBatchInfos = new ArrayList<>();
        for (String payoutBatchInfo : payoutBatchInfos) {
            PayoutBatchInfo info = new PayoutBatchInfo(payoutBatchInfo);
            this.payoutBatchInfos.add(info);
        }
    }

    /**
     * 获取
     *
     * @return commonResult
     */
    public CommonResult getCommonResult() {
        return this.commonResult;
    }

    /**
     * 设置
     *
     * @param commonResult
     */
    public void setCommonResult(CommonResult commonResult) {
        this.commonResult = commonResult;
    }

    @Override
    public String toString() {
        return "FortunePayoutBatchQueryResponseVO{" +
                "payoutBatchInfos=" + payoutBatchInfos +
                ", commonResult=" + commonResult +
                '}';
    }

    class PayoutBatchInfo{
        private String name;


        /**
         * 获取
         *
         * @return name
         */
        public String getName() {
            return this.name;
        }

        /**
         * 设置
         *
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        public  PayoutBatchInfo(String name){
            this.name = name;
        }
        @Override
        public String toString() {
            return "PayoutBatchInfo{" +
                    "name='" + name + '\'' +
                    '}';
        }
    }
}

