package com.yd.dal.entity.practitioner.payscale;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * ag_acl_life_practitioner_salary
 * @author 
 */
public class AgAclLifePractitionerSalary implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_practitioner.id 从业人员ID
     */
    private Long practitionerId;

    /**
     * 从业人员编号
     */
    private String practitionerCode;

    /**
     * 薪资年月
     */
    private String yearMonth;

    /**
     * 应发佣金
     */
    private BigDecimal payableAmount;

    /**
     * 扣除税金
     */
    private BigDecimal taxoutAmount;

    /**
     * 实发佣金
     */
    private BigDecimal netAmount;

    /**
     * 薪资单pdf文件
     */
    private String pdfOssPath;

    private String isBasic;


    /**
     * 0,预览薪资单，1，经纪人查看薪资单
     */
    private Integer isActive;
    private Long payoutBatchId;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPractitionerId() {
        return practitionerId;
    }

    public void setPractitionerId(Long practitionerId) {
        this.practitionerId = practitionerId;
    }

    public String getPractitionerCode() {
        return practitionerCode;
    }

    public void setPractitionerCode(String practitionerCode) {
        this.practitionerCode = practitionerCode;
    }

    public String getYearMonth() {
        return yearMonth;
    }

    public void setYearMonth(String yearMonth) {
        this.yearMonth = yearMonth;
    }

    public BigDecimal getPayableAmount() {
        return payableAmount;
    }

    public void setPayableAmount(BigDecimal payableAmount) {
        this.payableAmount = payableAmount;
    }

    public BigDecimal getTaxoutAmount() {
        return taxoutAmount;
    }

    public void setTaxoutAmount(BigDecimal taxoutAmount) {
        this.taxoutAmount = taxoutAmount;
    }

    public BigDecimal getNetAmount() {
        return netAmount;
    }

    public void setNetAmount(BigDecimal netAmount) {
        this.netAmount = netAmount;
    }

    public String getPdfOssPath() {
        return pdfOssPath;
    }

    public void setPdfOssPath(String pdfOssPath) {
        this.pdfOssPath = pdfOssPath;
    }

    public Integer getIsActive() {
        return isActive;
    }

    public void setIsActive(Integer isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        AgAclLifePractitionerSalary other = (AgAclLifePractitionerSalary) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getPractitionerId() == null ? other.getPractitionerId() == null : this.getPractitionerId().equals(other.getPractitionerId()))
            && (this.getPractitionerCode() == null ? other.getPractitionerCode() == null : this.getPractitionerCode().equals(other.getPractitionerCode()))
            && (this.getYearMonth() == null ? other.getYearMonth() == null : this.getYearMonth().equals(other.getYearMonth()))
            && (this.getPayableAmount() == null ? other.getPayableAmount() == null : this.getPayableAmount().equals(other.getPayableAmount()))
            && (this.getTaxoutAmount() == null ? other.getTaxoutAmount() == null : this.getTaxoutAmount().equals(other.getTaxoutAmount()))
            && (this.getNetAmount() == null ? other.getNetAmount() == null : this.getNetAmount().equals(other.getNetAmount()))
            && (this.getPayoutBatchId() == null ? other.getPayoutBatchId() == null : this.getPayoutBatchId().equals(other.getPayoutBatchId()))
            && (this.getPdfOssPath() == null ? other.getPdfOssPath() == null : this.getPdfOssPath().equals(other.getPdfOssPath()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getPractitionerId() == null) ? 0 : getPractitionerId().hashCode());
        result = prime * result + ((getPractitionerCode() == null) ? 0 : getPractitionerCode().hashCode());
        result = prime * result + ((getYearMonth() == null) ? 0 : getYearMonth().hashCode());
        result = prime * result + ((getPayableAmount() == null) ? 0 : getPayableAmount().hashCode());
        result = prime * result + ((getTaxoutAmount() == null) ? 0 : getTaxoutAmount().hashCode());
        result = prime * result + ((getNetAmount() == null) ? 0 : getNetAmount().hashCode());
        result = prime * result + ((getPayoutBatchId() == null) ? 0 : getPayoutBatchId().hashCode());
        result = prime * result + ((getPdfOssPath() == null) ? 0 : getPdfOssPath().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", practitionerId=").append(practitionerId);
        sb.append(", practitionerCode=").append(practitionerCode);
        sb.append(", yearMonth=").append(yearMonth);
        sb.append(", payableAmount=").append(payableAmount);
        sb.append(", taxoutAmount=").append(taxoutAmount);
        sb.append(", netAmount=").append(netAmount);
        sb.append(", pdfOssPath=").append(pdfOssPath);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }

    public String getIsBasic() {
        return isBasic;
    }

    public void setIsBasic(String isBasic) {
        this.isBasic = isBasic;
    }

	public Long getPayoutBatchId() {
		return payoutBatchId;
	}

	public void setPayoutBatchId(Long payoutBatchId) {
		this.payoutBatchId = payoutBatchId;
	}
    
}
