package com.yd.util.exception;

import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class MessageLocaleManager {
	
	private final static Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class); 
	 
	@Autowired
	private MessageSource messageSource;
	/**
	 * 国际化
	 * @param result
	 * @return
	 */
	public String getMessage(String code, Object[] params) {
	    String message = "";
	    try {
	        //Locale locale = LocaleContextHolder.getLocale();
	        Locale locale = new Locale("zh","CN");//中文，中国
	        message = messageSource.getMessage(code, params, locale);
	    } catch (Exception e) {
	    	logger.error("parse message error! ", e);
	    }
	    finally
	    {
	    }
	    return message;
	}
}
