package com.yd.dal.entity.meta;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * ag_object_collection_tagged
 * @author 
 */
@Data
public class ObjectCollectionTagged implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_md_tag.id
     */
    private Integer mdTagId;

    /**
     * 1=方案 2=产品 3=产品分类 4=客户 5=评价，对应类型id的集合tag_object_id（planId, productId,productCategoryId,planCategoryId,customerId,feedbackId）
     */
    private Integer taggedObjectType;

    /**
     * 便签对象id FK object table key id
     */
    private Long taggedObjectId;

    /**
     * 1=active 2=inactive
     */
    private Integer isActive;

    /**
     * 产品列表中推荐排序
     */
    private Integer recommendOrder;

    /**
     * UI产品列表中缺省的显示排序，推荐排序优先级高
     */
    private Integer displayOrder;

    private Date createdAt;

    /**
     * FK ag_acl_user.id
     */
    private Long createdBy;

    private Date updatedAt;

    /**
     * FK ag_acl_user.id
     */
    private Long updatedBy;

    private static final long serialVersionUID = 1L;
}