package com.yd.api.agms.vo.fortune;

import com.github.pagehelper.PageInfo;
import com.yd.dal.entity.agms.fortune.CommissionPayoutStatus;

import java.util.List;

/**
 * @author xxy
 */
public class CommissionPayoutStatusQueryRequestVO {
    /**
     * 发佣检核-佣金类型
     */
    private List<String> commissionTypeDropOptionCodeList;
    /**
     * 保单号
     */
    private String policyNo;
    /**
     * 保险公司
     */
    private Long insurerId;

    /**
     * 分公司
     */
    private Long insurerBranchId;

    /**
     * 营业部
     */
    private Long insurerBranchDeptId;

    /**
     * 体系
     */
    private Long subordinateSystemId;

    /**
     * 经纪人
     */
    private Long practitionerId;

    /**
     * 发佣状态  0-作废   1-待来佣   2-可发  3-保留  4-已发并关账
     */
    private Long commissionPayoutStatus;

    /**
     * 来佣检核年月
     */
    private String commissionPayoutYearmonth;

    /**
     * 实际发佣年月
     */
    private String payoutYearmonth;
    /**
     * 预计发佣年月
     */
    private String predictMonthPeriod;
    /**
     * 系统标志，区分公司营业部和体系，1，分公司，2营业部，3，S1分部,4,S2体系,5,S3纵队
     */
    private String systemFlag;
    private Long s3Id;
    private Long s2Id;
    private Long s1Id;
    /**
     * 渠道Id
     */
    private Long channelId;
    /**
     * 渠道类型: 对公:1; 对私:2
     */
    private String channelType;
    
    private PageInfo<CommissionPayoutStatus> page;

    public Long getInsurerId() {
        return insurerId;
    }

    public void setInsurerId(Long insurerId) {
        this.insurerId = insurerId;
    }

    public Long getInsurerBranchId() {
        return insurerBranchId;
    }

    public void setInsurerBranchId(Long insurerBranchId) {
        this.insurerBranchId = insurerBranchId;
    }

    public Long getInsurerBranchDeptId() {
        return insurerBranchDeptId;
    }

    public void setInsurerBranchDeptId(Long insurerBranchDeptId) {
        this.insurerBranchDeptId = insurerBranchDeptId;
    }

    public Long getSubordinateSystemId() {
        return subordinateSystemId;
    }

    public void setSubordinateSystemId(Long subordinateSystemId) {
        this.subordinateSystemId = subordinateSystemId;
    }

    public Long getPractitionerId() {
        return practitionerId;
    }

    public void setPractitionerId(Long practitionerId) {
        this.practitionerId = practitionerId;
    }

    public Long getCommissionPayoutStatus() {
        return commissionPayoutStatus;
    }

    public void setCommissionPayoutStatus(Long commissionPayoutStatus) {
        this.commissionPayoutStatus = commissionPayoutStatus;
    }

    public String getCommissionPayoutYearmonth() {
        return commissionPayoutYearmonth;
    }

    public void setCommissionPayoutYearmonth(String commissionPayoutYearmonth) {
        this.commissionPayoutYearmonth = commissionPayoutYearmonth;
    }

    public String getPayoutYearmonth() {
        return payoutYearmonth;
    }

    public void setPayoutYearmonth(String payoutYearmonth) {
        this.payoutYearmonth = payoutYearmonth;
    }


    public String getSystemFlag() {
        return systemFlag;
    }

    public void setSystemFlag(String systemFlag) {
        this.systemFlag = systemFlag;
    }

    public Long getS3Id() {
        return s3Id;
    }

    public void setS3Id(Long s3Id) {
        this.s3Id = s3Id;
    }

    public Long getS2Id() {
        return s2Id;
    }

    public void setS2Id(Long s2Id) {
        this.s2Id = s2Id;
    }

    public Long getS1Id() {
        return s1Id;
    }

    public void setS1Id(Long s1Id) {
        this.s1Id = s1Id;
    }

    @Override
    public String toString() {
        return "CommissionPayoutStatusQueryRequestVO{" +
                "insurerId=" + insurerId +
                ", insurerBranchId=" + insurerBranchId +
                ", insurerBranchDeptId=" + insurerBranchDeptId +
                ", subordinateSystemId=" + subordinateSystemId +
                ", practitionerId=" + practitionerId +
                ", commissionPayoutStatus=" + commissionPayoutStatus +
                ", commissionPayoutYearmonth='" + commissionPayoutYearmonth + '\'' +
                ", payoutYearmonth='" + payoutYearmonth + '\'' +
                '}';
    }

    public PageInfo<CommissionPayoutStatus> getPage() {
        return page;
    }

    public void setPage(PageInfo<CommissionPayoutStatus> page) {
        this.page = page;
    }

    public String getPredictMonthPeriod() {
        return predictMonthPeriod;
    }

    public void setPredictMonthPeriod(String predictMonthPeriod) {
        this.predictMonthPeriod = predictMonthPeriod;
    }

    public String getPolicyNo() {
        return policyNo;
    }

    public void setPolicyNo(String policyNo) {
        this.policyNo = policyNo;
    }

    public List<String> getCommissionTypeDropOptionCodeList() {
        return commissionTypeDropOptionCodeList;
    }

    public void setCommissionTypeDropOptionCodeList(List<String> commissionTypeDropOptionCodeList) {
        this.commissionTypeDropOptionCodeList = commissionTypeDropOptionCodeList;
    }

	public Long getChannelId() {
		return channelId;
	}

	public void setChannelId(Long channelId) {
		this.channelId = channelId;
	}

	public String getChannelType() {
		return channelType;
	}

	public void setChannelType(String channelType) {
		this.channelType = channelType;
	}
    
}

