package com.yd.rmi.n22.staff.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yd.rmi.n22.common.utils.N22Utils;
import com.yd.rmi.n22.policy.service.impl.N22PolicyServiceImpl;
import com.yd.rmi.n22.staff.pojo.GetStaffNewRequestBody;
import com.yd.rmi.n22.staff.pojo.GetStaffNewResponseVO;
import com.yd.rmi.n22.staff.pojo.Staff;
import com.yd.rmi.n22.staff.service.N22StaffService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.UUID;

@Service
public class N22StaffServiceImpl implements N22StaffService {
    private final static Logger logger = LoggerFactory.getLogger(N22PolicyServiceImpl.class);

    @Override
    public GetStaffNewResponseVO getStaffNew(GetStaffNewRequestBody getStaffNewRequestBody) {

        JSONObject obj = new JSONObject(); //传参
        JSONObject rObj; //返回结果

        JSONObject requestHead = new JSONObject();
        requestHead.put("seqNo", UUID.randomUUID().toString());

        obj.put("requestHead", requestHead);
        obj.put("requestBody", getStaffNewRequestBody);
        logger.info("N22员工查询请求报文："+obj.toString());

//        String url = "https://life.ydinsurance.cn/EliteGeneralHttpTask/GeneralService/getStaffNew";
        String url = "http://101.132.32.185:8082/EliteGeneralHttpTask/GeneralService/getStaffNew";
        String result = N22Utils.postTransaction(url, obj.toString());

        logger.info("N22员工查询响应报文："+result);
        GetStaffNewResponseVO response = JSONObject.parseObject(result, GetStaffNewResponseVO.class);




        return response;
    }
}
